/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.converter;

import jetbrains.mps.webr.runtime.converter.FixedClassConverter;
import jetbrains.mps.webr.runtime.converter.LocalizedWrongFormatException;

public class Java_lang_IntegerConverter
extends FixedClassConverter {
    public Java_lang_IntegerConverter() {
        super(Integer.class);
    }

    @Override
    public String toString(Object value) {
        return this.doToString((Integer)value);
    }

    private String doToString(Integer value) {
        return String.valueOf(value);
    }

    @Override
    public Object fromString(String typeName, String valueAsString) {
        if ("".equals(valueAsString)) {
            valueAsString = null;
        }
        if (valueAsString == null) {
            return null;
        }
        try {
            return Integer.parseInt(valueAsString);
        }
        catch (NumberFormatException e) {
            throw new LocalizedWrongFormatException(typeName, "jetbrains.webr_dnq.integer_converter_format_exception", valueAsString);
        }
    }
}

