/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.converter;

import jetbrains.mps.webr.runtime.converter.FixedClassConverter;
import jetbrains.mps.webr.runtime.converter.LocalizedWrongFormatException;
import jetbrains.mps.webr.runtime.converter.NullConvertException;

public class Java_lang_LongConverter
extends FixedClassConverter {
    public Java_lang_LongConverter() {
        super(Long.class);
    }

    @Override
    public String toString(Object value) {
        return this.doToString((Long)value);
    }

    private String doToString(Long value) {
        return String.valueOf(value);
    }

    @Override
    public Object fromString(String typeName, String valueAsString) {
        if ("".equals(valueAsString)) {
            valueAsString = null;
        }
        if (valueAsString == null) {
            return null;
        }
        if (valueAsString == null) {
            throw new NullConvertException(typeName);
        }
        try {
            return Long.parseLong(valueAsString);
        }
        catch (NumberFormatException e) {
            throw new LocalizedWrongFormatException(typeName, "jetbrains.webr_dnq.long_converter_format_exception", valueAsString);
        }
    }
}

