/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.filter;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.webr.runtime.filter.QueryParameterListener;
import jetbrains.mps.webr.runtime.filter.QueryParametersParser;

public class CharismaHttpServletRequestWrapper
extends HttpServletRequestWrapper
implements QueryParameterListener {
    private Map<String, List<String>> parameters;
    private Map<String, String[]> fixedParameters;
    private String uri;

    public CharismaHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        try {
            this.setCharacterEncoding(StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.parseParameters();
    }

    public String getParameter(String key) {
        if (MapSequence.fromMap(this.parameters).containsKey((Object)key)) {
            return (String)ListSequence.fromList((List)((List)MapSequence.fromMap(this.parameters).get((Object)key))).first();
        }
        return super.getParameter(key);
    }

    public Enumeration getParameterNames() {
        if (this.fixedParameters == null) {
            this.fixedParameters = MapSequence.fromMap(new HashMap());
            for (String key : SetSequence.fromSet((Set)MapSequence.fromMap(this.parameters).keySet())) {
                MapSequence.fromMap(this.fixedParameters).put((Object)key, (Object)ListSequence.fromList((List)((List)MapSequence.fromMap(this.parameters).get((Object)key))).toGenericArray(String.class));
            }
            MapSequence.fromMap(this.fixedParameters).putAll(super.getParameterMap());
        }
        return Collections.enumeration(MapSequence.fromMap(this.fixedParameters).keySet());
    }

    public Map getParameterMap() {
        if (this.fixedParameters == null) {
            this.fixedParameters = MapSequence.fromMap(new HashMap());
            MapSequence.fromMap(this.fixedParameters).putAll(super.getParameterMap());
            for (String key : SetSequence.fromSet((Set)MapSequence.fromMap(this.parameters).keySet())) {
                MapSequence.fromMap(this.fixedParameters).put((Object)key, (Object)ListSequence.fromList((List)((List)MapSequence.fromMap(this.parameters).get((Object)key))).toGenericArray(String.class));
            }
        }
        return this.fixedParameters;
    }

    public String[] getParameterValues(String key) {
        if (MapSequence.fromMap(this.parameters).containsKey((Object)key)) {
            return (String[])ListSequence.fromList((List)((List)MapSequence.fromMap(this.parameters).get((Object)key))).toGenericArray(String.class);
        }
        return super.getParameterValues(key);
    }

    private void parseParameters() {
        String queryString = this.getQueryString();
        if (queryString == null) {
            return;
        }
        QueryParametersParser parametersParser = new QueryParametersParser(queryString, this);
        parametersParser.parse();
    }

    @Override
    public void parameter(String key, String value) {
        if (key == null) {
            return;
        }
        try {
            try {
                key = URLDecoder.decode(key, this.getCharacterEncoding());
            }
            catch (IllegalArgumentException ex) {
                return;
            }
            try {
                value = URLDecoder.decode(value, this.getCharacterEncoding());
            }
            catch (IllegalArgumentException ex) {
                value = "";
            }
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException();
        }
        if (this.parameters == null) {
            this.parameters = MapSequence.fromMap(new HashMap());
        }
        if (!MapSequence.fromMap(this.parameters).containsKey((Object)key)) {
            MapSequence.fromMap(this.parameters).put((Object)key, (Object)ListSequence.fromList(new ArrayList()));
        }
        ListSequence.fromList((List)((List)MapSequence.fromMap(this.parameters).get((Object)key))).addElement((Object)value);
    }

    public String getRequestURI() {
        if (this.uri == null) {
            String uri = super.getRequestURI();
            int index = uri.indexOf(";");
            this.uri = index < 0 ? uri : uri.substring(0, index);
        }
        return this.uri;
    }
}

