/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.filter;

import jetbrains.mps.webr.runtime.filter.QueryParameterListener;

public class QueryParametersParser {
    private static final String EMPTY_STRING = "";
    private String inputString;
    private int current;
    private int keyStart;
    private int keyEnd;
    private int valueStart;
    private QueryParameterListener parameterListener;
    private State state;

    public QueryParametersParser(String inputString, QueryParameterListener parameterListener) {
        this.inputString = inputString;
        this.parameterListener = parameterListener;
        this.current = 0;
        this.state = State.START;
    }

    public void parse() {
        if (QueryParametersParser.isNotEmpty_x00t6g_a0a0a(this.inputString)) {
            while (this.current < this.inputString.length()) {
                switch (this.inputString.charAt(this.current)) {
                    case '=': {
                        this.equals();
                        break;
                    }
                    case '&': {
                        this.end();
                        break;
                    }
                    default: {
                        this.character();
                    }
                }
                ++this.current;
            }
        }
        this.eol();
    }

    private void pushKey(String key) {
        this.parameterListener.parameter(key, EMPTY_STRING);
    }

    private void pushParameter(String key, String value) {
        this.parameterListener.parameter(key, value);
    }

    private void pushEnd() {
        this.parameterListener.parameter(null, null);
    }

    public void character() {
        switch (this.state) {
            case PARSING: {
                break;
            }
            case START: {
                this.state = State.READ_KEY;
                this.PARSING_READ_KEY_enter();
                break;
            }
            case READ_KEY: {
                break;
            }
            case READ_VALUE: {
                break;
            }
        }
    }

    public void equals() {
        switch (this.state) {
            case PARSING: {
                break;
            }
            case START: {
                this.keyStart = this.keyEnd;
                this.state = State.READ_VALUE;
                this.PARSING_READ_VALUE_enter();
                break;
            }
            case READ_KEY: {
                this.PARSING_READ_KEY_exit();
                this.state = State.READ_VALUE;
                this.PARSING_READ_VALUE_enter();
                break;
            }
            case READ_VALUE: {
                break;
            }
        }
    }

    public void end() {
        switch (this.state) {
            case PARSING: {
                break;
            }
            case START: {
                break;
            }
            case READ_KEY: {
                this.PARSING_READ_KEY_exit();
                this.pushKey(this.inputString.substring(this.keyStart, this.keyEnd));
                this.state = State.START;
                break;
            }
            case READ_VALUE: {
                this.PARSING_READ_VALUE_exit();
                this.state = State.START;
                break;
            }
        }
    }

    public void eol() {
        switch (this.state) {
            case PARSING: {
                this.state = State.FINISH;
                break;
            }
            case START: {
                this.state = State.FINISH;
                break;
            }
            case READ_KEY: {
                this.PARSING_READ_KEY_exit();
                if (this.keyStart != this.keyEnd) {
                    this.pushKey(this.inputString.substring(this.keyStart, this.keyEnd));
                }
                this.state = State.FINISH;
                break;
            }
            case READ_VALUE: {
                this.PARSING_READ_VALUE_exit();
                this.state = State.FINISH;
                break;
            }
        }
    }

    public boolean isInState(State state) {
        if (this.state == state) {
            return true;
        }
        switch (state) {
            case PARSING: {
                switch (this.state) {
                    case START: {
                        return true;
                    }
                    case READ_KEY: {
                        return true;
                    }
                    case READ_VALUE: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public State _state() {
        return this.state;
    }

    private void PARSING_READ_KEY_enter() {
        this.keyStart = this.current;
    }

    private void PARSING_READ_KEY_exit() {
        this.keyEnd = this.current;
    }

    private void PARSING_READ_VALUE_enter() {
        this.valueStart = this.current + 1;
    }

    private void PARSING_READ_VALUE_exit() {
        if (this.keyStart != this.keyEnd) {
            this.pushParameter(this.inputString.substring(this.keyStart, this.keyEnd), this.inputString.substring(this.valueStart, this.current));
        } else {
            this.pushParameter(EMPTY_STRING, this.inputString.substring(this.valueStart, this.current));
        }
    }

    public static boolean isNotEmpty_x00t6g_a0a0a(String str) {
        return str != null && str.length() > 0;
    }

    public static enum State {
        PARSING,
        START,
        READ_KEY,
        READ_VALUE,
        FINISH;

    }
}

