/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.freemarker;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import webr.framework.controller.BaseApplication;

public class PreprocessCssUrlsDirective
implements TemplateDirectiveModel {
    public static Pattern CSS_URL = Pattern.compile("url\\s*\\(\\s*([^)]*)\\s*\\)");

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String path = params.get("path").toString();
        StringWriter sw = new StringWriter();
        body.render((Writer)sw);
        env.getOut().write(this.preprocessCssUrls(sw.toString(), path));
    }

    private String preprocessCssUrls(String input, String path) throws IOException {
        StringBuilder res = new StringBuilder();
        Matcher m = CSS_URL.matcher(input);
        int prev = 0;
        while (m.find()) {
            res.append(input.substring(prev, m.start()));
            res.append("url('").append(this.getAbsoluteUrl(m.group(1), path)).append("')");
            prev = m.end();
        }
        res.append(input.substring(prev));
        return res.toString();
    }

    private String getAbsoluteUrl(String cssUrl, String path) {
        if ((cssUrl = cssUrl.trim()).startsWith("'") || cssUrl.startsWith("\"")) {
            cssUrl = cssUrl.substring(1, cssUrl.length() - 1).trim();
        }
        return cssUrl.startsWith("/") ? cssUrl : BaseApplication.getFullContextPath() + "/" + "_classpath" + this.getResourceDirectory(path) + "/" + cssUrl;
    }

    public String getResourceDirectory(String path) {
        return path.substring(0, path.lastIndexOf("/"));
    }
}

