/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.requestProcessor;

import java.util.Map;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.url.RequestUri;
import webr.framework.controller.requestProcessor.RequestProcessor;
import webr.framework.runtime.response.ResponseAction;

public class ClasspathRequestProcessor
implements RequestProcessor {
    private Map<RequestProcessor, String> dependentRequestProcessors;

    @Override
    public boolean isApplicable(RequestUri requestUri) {
        String expectedController;
        String actualController = requestUri.getElement(0);
        return actualController == (expectedController = "_classpath") || actualController != null && actualController.equalsIgnoreCase(expectedController);
    }

    @Override
    public Map<RequestProcessor, String> getDependentRequestProcessors() {
        return this.dependentRequestProcessors;
    }

    public void setDependentRequestProcessors(Map<RequestProcessor, String> precedingRequestProcessors) {
        this.dependentRequestProcessors = precedingRequestProcessors;
    }

    @Override
    public ResponseAction processRequest(RequestUri requestUri) {
        String path = requestUri.getTail(1);
        return ResponseFactory.getInstance().getResourceResponse(path);
    }
}

