/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.requestProcessor;

import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpSession;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.requestProcessor.WindowManager;
import jetbrains.mps.webr.runtime.session.WebrSessionListenerImpl;
import jetbrains.mps.webr.runtime.templateComponent.ActionController;
import jetbrains.mps.webr.runtime.templateComponent.TemplateActionController;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.mps.webr.runtime.url.RequestUri;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import webr.framework.controller.BaseApplication;
import webr.framework.controller.ControllerOperations;
import webr.framework.controller.requestProcessor.RequestProcessor;
import webr.framework.runtime.response.ResponseAction;
import webr.framework.url.UrlUtil;

public class EventRequestProcessor
implements RequestProcessor {
    protected static Log log = LogFactory.getLog(EventRequestProcessor.class);
    private Map<RequestProcessor, String> dependentRequestProcessors;

    @Override
    public boolean isApplicable(RequestUri requestUri) {
        String expectedController;
        String actualController = requestUri.getElement(0);
        return actualController == (expectedController = "_events") || actualController != null && actualController.equalsIgnoreCase(expectedController);
    }

    @Override
    public Map<RequestProcessor, String> getDependentRequestProcessors() {
        return this.dependentRequestProcessors;
    }

    public void setDependentRequestProcessors(Map<RequestProcessor, String> precedingRequestProcessors) {
        this.dependentRequestProcessors = precedingRequestProcessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseAction processRequest(RequestUri requestUri) {
        try {
            ResponseAction responseAction;
            WindowManager windowManager = WindowManager.getWindowManager();
            String windowId = windowManager.getRequestWindowId();
            ResponseAction responseAction2 = null;
            if (windowId != null) {
                ActionController actionController = windowManager.getActionController(windowId);
                if (actionController == null) {
                    Object oldSession;
                    HttpSession currSession;
                    String oldSessionId = BaseApplication.getRequest().getParameter("http_session_id");
                    if (EventRequestProcessor.neq_jpir3i_a0d0b0e0a0d(oldSessionId, (currSession = BaseApplication.getRequest().getSession()).getId())) {
                        oldSession = this.getSession(oldSessionId);
                        actionController = this.findController((HttpSession)oldSession, windowId, windowManager);
                        EventRequestProcessor.mergeSessions(currSession, oldSession);
                    }
                    if (actionController == null) {
                        oldSession = ResponseFactory.getJsResponseFactory().getReconnectedResponse();
                        return oldSession;
                    }
                }
                if (actionController instanceof TemplateActionController) {
                    TemplateActionController templateActionController = (TemplateActionController)actionController;
                    String eventSource = ControllerOperations.getEventSource();
                    String eventName = ControllerOperations.getEventName();
                    try {
                        responseAction2 = templateActionController.handleEvent(eventSource, eventName);
                    }
                    catch (Throwable e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Error while processing event [" + eventSource + ":" + eventName + "]"), e);
                        }
                        BaseApplication.setSessionField("POSTPONED_EXCEPTION", e);
                        ResponseAction responseAction3 = ResponseFactory.getInstance().getRedirectResponse(UrlUtil.getDispatchActionUrl("_InternalErrorThrow", "", new QueryParameter[0]));
                        if (log.isTraceEnabled()) {
                            log.trace((Object)DnqUtils.getTransactionsDump());
                        }
                        return responseAction3;
                    }
                }
            }
            if (!BaseApplication.getCompositeCommand().isEmpty()) {
                responseAction = BaseApplication.getCompositeCommand();
                return responseAction;
            }
            responseAction = responseAction2 == null ? ControllerOperations.getDefaultResponseAction() : responseAction2;
            return responseAction;
        }
        finally {
            if (log.isTraceEnabled()) {
                log.trace((Object)DnqUtils.getTransactionsDump());
            }
        }
    }

    private ActionController findController(HttpSession oldSession, String windowId, WindowManager currWindowManager) {
        WindowManager oldWindowManager = WindowManager.getWindowManager(oldSession);
        ActionController actionController = null;
        if (oldWindowManager != null && (actionController = oldWindowManager.getActionController(windowId)) != null) {
            currWindowManager.replaceActionController(windowId, actionController);
        }
        return actionController;
    }

    private HttpSession getSession(String sessionId) {
        return WebrSessionListenerImpl.getInstance().getSession(sessionId);
    }

    public static HttpSession mergeSessions(@NotNull HttpSession newSession, HttpSession oldSession) {
        Map<String, Serializable> oldSessionVars;
        try {
            oldSessionVars = BaseApplication.getSessionBean(oldSession);
        }
        catch (Exception e) {
            return newSession;
        }
        if (oldSessionVars != null) {
            Map<String, Serializable> newSessionVars = null;
            try {
                newSessionVars = BaseApplication.getSessionBean(newSession);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (newSessionVars != null) {
                oldSessionVars.putAll(newSessionVars);
            }
            BaseApplication.setSessionBean(newSession, oldSessionVars);
        }
        return newSession;
    }

    private static boolean neq_jpir3i_a0d0b0e0a0d(Object a, Object b) {
        return !(a == null ? a == b : a.equals(b));
    }
}

