/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.requestProcessor;

import java.util.Map;
import jetbrains.mps.webr.runtime.requestProcessor.ActionControllerUtil;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.templateComponent.RootTemplateController;
import jetbrains.mps.webr.runtime.templateComponent.RootTemplateControllerContainer;
import jetbrains.mps.webr.runtime.url.RequestUri;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.requestProcessor.RequestProcessor;
import webr.framework.runtime.response.ResponseAction;

public class HtmlTemplateRequestProcessor
implements RequestProcessor {
    protected static Log log = LogFactory.getLog(HtmlTemplateRequestProcessor.class);
    private Map<RequestProcessor, String> dependentRequestProcessors;

    @Override
    public boolean isApplicable(RequestUri requestUri) {
        String controller = requestUri.getElement(0);
        return ((RootTemplateControllerContainer)ServiceLocator.getBean((String)"rootTemplateControllerContainer")).containsTemplate(controller);
    }

    @Override
    public Map<RequestProcessor, String> getDependentRequestProcessors() {
        return this.dependentRequestProcessors;
    }

    public void setDependentRequestProcessors(Map<RequestProcessor, String> precedingRequestProcessors) {
        this.dependentRequestProcessors = precedingRequestProcessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseAction processRequest(RequestUri requestUri) {
        try {
            String templateName = requestUri.getElement(0);
            RootTemplateController rootTemplateController = ((RootTemplateControllerContainer)ServiceLocator.getBean((String)"rootTemplateControllerContainer")).getRootTemplateController(templateName);
            ResponseAction responseAction = rootTemplateController == null ? ResponseFactory.getInstance().getNotFoundResponse("Cannot find template: " + templateName) : ActionControllerUtil.processRequest(rootTemplateController, templateName, requestUri.getTail(1, false));
            ResponseAction responseAction2 = responseAction;
            return responseAction2;
        }
        finally {
            if (log.isTraceEnabled()) {
                log.trace((Object)DnqUtils.getTransactionsDump());
            }
        }
    }
}

