/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.requestProcessor;

import eu.medsea.mimeutil.MimeUtil2;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.webr.runtime.builderContext.BuilderThreadContext;
import jetbrains.mps.webr.runtime.cache.CacheControlUtil;
import jetbrains.mps.webr.runtime.requestProcessor.JsResponseFactory;
import jetbrains.mps.webr.runtime.requestProcessor.MimeType;
import jetbrains.mps.webr.runtime.servlet.ResourceWrapper;
import jetbrains.mps.webr.runtime.servlet.ServletUtil;
import jetbrains.mps.webr.runtime.templateComponent.TemplateComponent;
import jetbrains.mps.webr.runtime.uri.hash.HashFileNameUtil;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import webr.framework.controller.BaseApplication;
import webr.framework.runtime.response.ErrorResponseAction;
import webr.framework.runtime.response.ResponseAction;
import webr.framework.textBuilder.TBuilderContext;
import webr.framework.textBuilder.TextBuilder;
import webr.framework.textBuilder.WebrBuffer;
import webr.framework.textBuilder.WebrBuilderContext;

public class ResponseFactory {
    private static ResponseFactory instance;
    private static JsResponseFactory jsInstance;
    private static Set<String> UNCHECKED_RESOURCES;
    private static Set<String> DISPOSITION_ATTACHMENT_MIMES;
    private static boolean contentDispositionAttachment;
    protected static Log log;

    protected ResponseFactory() {
    }

    public ResponseAction getTextContentResponse(final MimeType mimeType, String content) {
        final byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        ResponseAction action = new ResponseAction(){

            @Override
            public void doAction(HttpServletResponse response) throws IOException {
                response.setContentType(mimeType.getPresentation());
                response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
                CacheControlUtil.setNonCacheableHeaders(response);
                response.getOutputStream().write(bytes);
            }
        };
        return action;
    }

    public ResponseAction getHtmlRenderResponseAction(final TemplateComponent tc, final TBuilderContext bc, final _FunctionTypes._void_P0_E0 onFinish) {
        if (tc == null) {
            return null;
        }
        ResponseAction action = new ResponseAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doAction(HttpServletResponse response) throws IOException {
                try {
                    int code = tc.getResponseStatusCode();
                    if (code != 200) {
                        response.setStatus(code);
                    }
                    response.setContentType(MimeType.TEXT_HTML.getPresentation());
                    response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
                    CacheControlUtil.setNonCacheableHeaders(response);
                    bc.start((ServletResponse)response);
                    tc.render(bc);
                    if (WebrBuffer.USE_CHAR_SEQUENCE) {
                        CharSequence content = bc.getCharSequence();
                        if (content != null) {
                            WebrBuilderContext.writeCharSequence(content, response.getWriter());
                        }
                    } else {
                        String content = bc.getText();
                        if (content != null) {
                            response.getWriter().write(content);
                        }
                    }
                    bc.end();
                }
                finally {
                    onFinish.invoke();
                }
            }
        };
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAction getXmlRenderResponseAction(TextBuilder textBuilder, Map<String, Object> rootMap) {
        TBuilderContext builderContext = new TBuilderContext();
        ResponseAction responseAction = null;
        if (textBuilder != null) {
            String text = null;
            BuilderThreadContext.initNonLocalBuilderThreadContext();
            try {
                text = textBuilder.getText(rootMap, builderContext);
            }
            finally {
                BuilderThreadContext.close();
            }
            responseAction = this.getTextContentResponse(MimeType.TEXT_XML, text);
        }
        return responseAction;
    }

    public ResponseAction getResourceResponse(String hashPath) {
        Wrappers._T resourcePath;
        ResponseAction responseAction;
        block6: {
            responseAction = null;
            resourcePath = new Wrappers._T(null);
            try {
                resourcePath.value = HashFileNameUtil.getPath(hashPath);
                String hashPath1 = HashFileNameUtil.getHashPath((String)resourcePath.value, false);
                String hashPath2 = HashFileNameUtil.getHashPath((String)resourcePath.value, true);
                final ResourceWrapper rw = ServletUtil.getResourceWrapper((String)resourcePath.value);
                if (rw != null && rw.exists()) {
                    String ext = FilenameUtils.getExtension((String)((String)resourcePath.value));
                    if (!UNCHECKED_RESOURCES.contains(ext) && ResponseFactory.neq_n52i0k_a0a0a1a4a2a3(hashPath1, hashPath) && ResponseFactory.neq_n52i0k_a0a0a1a4a2a3_0(hashPath2, hashPath)) {
                        rw.close();
                        responseAction = this.getForbiddenResponse("No access to resource [" + (String)resourcePath.value + "] by url [" + hashPath + "]");
                    } else {
                        responseAction = new ResponseAction(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void doAction(HttpServletResponse response) throws IOException {
                                try {
                                    ServletContext servletContext = BaseApplication.getServletContext();
                                    String mimeType = servletContext.getMimeType((String)resourcePath.value);
                                    if (mimeType != null && mimeType.length() > 0) {
                                        response.setContentType(mimeType);
                                    }
                                    CacheControlUtil.setHeaders(response, true);
                                    IOUtils.copy((InputStream)rw.inputStream(), (OutputStream)response.getOutputStream());
                                }
                                finally {
                                    rw.close();
                                }
                            }
                        };
                    }
                }
            }
            catch (IllegalArgumentException e) {
                if (!log.isWarnEnabled()) break block6;
                log.warn((Object)("Error accessing resource " + hashPath + ": " + e.getMessage()));
            }
        }
        if (responseAction == null) {
            responseAction = this.getNotFoundResponse("Resource [" + (resourcePath.value == null ? hashPath : (String)resourcePath.value) + "] was not found");
        }
        return responseAction;
    }

    public ResponseAction getNotFoundResponse(String message) {
        return new ErrorResponseAction(404, message);
    }

    public ResponseAction getNotFoundResponse() {
        return new ErrorResponseAction(404, null);
    }

    public ResponseAction getBadRequest(String message) {
        return new ErrorResponseAction(400, message);
    }

    public ResponseAction getForbiddenResponse(String message) {
        return new ErrorResponseAction(403, message);
    }

    public ResponseAction getInternalServerErrorResponse(String message) {
        if (log.isErrorEnabled()) {
            log.error((Object)message);
        }
        return new ErrorResponseAction(500, message);
    }

    public ResponseAction getNotImplementedServerErrorResponse(String message) {
        return new ErrorResponseAction(501, message);
    }

    public ResponseAction getSendFileResponse(String mimeType, String fileName, @NotNull InputStream is, boolean cache) {
        return this.getSendFileResponse(mimeType, fileName, is, cache, -1L, false);
    }

    public ResponseAction getSendFileResponse(String mimeType, final String fileName, final @NotNull InputStream is, final boolean cache, final long size, final boolean trusted) {
        final Wrappers._T _mimeType = new Wrappers._T((Object)mimeType);
        ResponseAction action = new ResponseAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doAction(HttpServletResponse response) throws IOException {
                try {
                    if (_mimeType.value != null && ((String)_mimeType.value).length() > 0) {
                        _mimeType.value = ((String)_mimeType.value).split(" ")[0];
                        response.setContentType(((String)_mimeType.value).startsWith("text/") ? MimeUtil2.UNKNOWN_MIME_TYPE.toString() : (String)_mimeType.value);
                    } else {
                        response.setContentType(MimeUtil2.UNKNOWN_MIME_TYPE.toString());
                    }
                    StringBuilder contentDisposition = new StringBuilder(ResponseFactory.this.isContentDispositionAttachment((String)_mimeType.value) && !trusted ? "attachment; " : "");
                    CharsetEncoder enc = StandardCharsets.US_ASCII.newEncoder();
                    boolean canEncode = enc.canEncode(fileName);
                    if (canEncode) {
                        contentDisposition.append("fileName=").append('\"').append(fileName).append('\"');
                    } else {
                        URI uri;
                        String encodedFilename = ResponseFactory.this.encodeFileName(fileName, enc);
                        if (encodedFilename != null && encodedFilename.length() > 0) {
                            contentDisposition.append("filename=").append('\"').append(encodedFilename).append('\"');
                        }
                        if ((uri = ResponseFactory.this.getURIEncodedFileName(fileName)) != null) {
                            String asciiEncodedFileNameWithoutCommas = uri.toASCIIString().replaceAll(",", "%2C");
                            contentDisposition.append("; filename*=UTF-8''").append(asciiEncodedFileNameWithoutCommas);
                        }
                    }
                    response.setHeader("Content-Disposition", contentDisposition.toString());
                    if (size > 0L) {
                        response.setContentLength((int)size);
                    }
                    CacheControlUtil.setHeaders(response, cache);
                    IOUtils.copyLarge((InputStream)is, (OutputStream)response.getOutputStream());
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        return action;
    }

    private boolean isContentDispositionAttachment(String mimeType) {
        if (contentDispositionAttachment && mimeType != null && mimeType.length() > 0) {
            for (String pattern : DISPOSITION_ATTACHMENT_MIMES) {
                if (!mimeType.toLowerCase().matches(pattern.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public URI getURIEncodedFileName(String fileName) {
        try {
            return new URI(null, null, fileName, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String encodeFileName(String fileName, CharsetEncoder enc) {
        ByteBuffer bbuf;
        enc.onMalformedInput(CodingErrorAction.REPLACE);
        enc.onUnmappableCharacter(CodingErrorAction.REPLACE);
        String normalizedFilename = Normalizer.normalize(fileName, Normalizer.Form.NFKD);
        CharBuffer cbuf = CharBuffer.wrap(normalizedFilename);
        try {
            bbuf = enc.encode(cbuf);
        }
        catch (CharacterCodingException e) {
            bbuf = ByteBuffer.allocate(0);
        }
        return new String(bbuf.array(), bbuf.position(), bbuf.limit(), StandardCharsets.US_ASCII);
    }

    public ResponseAction getRedirectResponse(final String url) {
        ResponseAction action = new ResponseAction(){

            @Override
            public void doAction(HttpServletResponse response) throws IOException {
                response.sendRedirect(url);
            }
        };
        return action;
    }

    public ResponseAction getRedirectBackResponse() {
        return this.getInternalServerErrorResponse("Can't redirect back");
    }

    public ResponseAction getRedirectSelfResponse() {
        return this.getInternalServerErrorResponse("Can't redirect self");
    }

    public ResponseAction getDefaultResponse() {
        return this.getRedirectSelfResponse();
    }

    public ResponseAction getDoNothingResponse() {
        return this.getInternalServerErrorResponse("Can't do nothing");
    }

    public ResponseAction getAuthRequiredResponse(final String realm) {
        ResponseAction action = new ResponseAction(){

            @Override
            public void doAction(HttpServletResponse response) throws IOException {
                response.setStatus(401, "Authorization required");
                response.setHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
            }
        };
        return action;
    }

    public static ResponseFactory getInstance() {
        if (!ResponseFactory.isXMLHttpRequest()) {
            if (instance == null) {
                instance = new ResponseFactory();
            }
            return instance;
        }
        return ResponseFactory.getJsResponseFactory();
    }

    public static JsResponseFactory getJsResponseFactory() {
        if (jsInstance == null) {
            jsInstance = new JsResponseFactory();
        }
        return jsInstance;
    }

    public static boolean isXMLHttpRequest() {
        String requestedWith;
        HttpServletRequest request = BaseApplication.getRequest();
        boolean xmlHttpRequest = false;
        if (request != null && !(xmlHttpRequest = "XMLHttpRequest".equalsIgnoreCase(requestedWith = request.getHeader("X-Requested-With"))) && ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            requestedWith = request.getParameter("X-Requested-With");
            xmlHttpRequest = "XMLHttpRequest".equalsIgnoreCase(requestedWith);
        }
        return xmlHttpRequest;
    }

    public static void setContentDispositionAttachment(boolean _contentDispositionAttachment) {
        contentDispositionAttachment = _contentDispositionAttachment;
    }

    public static void setMimeForContentDispositionAttachment(String mime) {
        DISPOSITION_ATTACHMENT_MIMES.add(mime);
    }

    public static void removeMimeForContentDispositionAttachment(String mime) {
        DISPOSITION_ATTACHMENT_MIMES.remove(mime);
    }

    private static boolean neq_n52i0k_a0a0a1a4a2a3(Object a, Object b) {
        return !(a == null ? a == b : a.equals(b));
    }

    private static boolean neq_n52i0k_a0a0a1a4a2a3_0(Object a, Object b) {
        return !(a == null ? a == b : a.equals(b));
    }

    static {
        UNCHECKED_RESOURCES = new HashSet<String>();
        DISPOSITION_ATTACHMENT_MIMES = new ConcurrentSkipListSet<String>();
        contentDispositionAttachment = true;
        log = LogFactory.getLog(ResponseFactory.class);
        UNCHECKED_RESOURCES.add("css");
        UNCHECKED_RESOURCES.add("js");
        UNCHECKED_RESOURCES.add("html");
        UNCHECKED_RESOURCES.add("htm");
        UNCHECKED_RESOURCES.add("gif");
        UNCHECKED_RESOURCES.add("png");
        UNCHECKED_RESOURCES.add("jpeg");
        UNCHECKED_RESOURCES.add("jpg");
        UNCHECKED_RESOURCES.add("ico");
        UNCHECKED_RESOURCES.add("jar");
        UNCHECKED_RESOURCES.add("zip");
        UNCHECKED_RESOURCES.add("jnlp");
        UNCHECKED_RESOURCES.add("swf");
        UNCHECKED_RESOURCES.add("htc");
        UNCHECKED_RESOURCES.add("woff");
        UNCHECKED_RESOURCES.add("ttf");
        UNCHECKED_RESOURCES.add("eot");
        UNCHECKED_RESOURCES.add("eot");
        UNCHECKED_RESOURCES.add("svg");
        DISPOSITION_ATTACHMENT_MIMES.add("text/.*");
    }
}

