/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.requestProcessor;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import jetbrains.mps.webr.runtime.requestProcessor.RestHandler;
import jetbrains.mps.webr.runtime.url.RequestUri;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.requestProcessor.RequestProcessor;
import webr.framework.runtime.response.ResponseAction;

public class RestRequestProcessor
implements RequestProcessor {
    private static ResponseAction EMPTY = new ResponseAction(){

        @Override
        public void doAction(HttpServletResponse res) throws IOException {
        }
    };
    protected static Log log = LogFactory.getLog(RestRequestProcessor.class);
    private Map<RequestProcessor, String> dependentRequestProcessors;

    @Override
    public boolean isApplicable(RequestUri requestUri) {
        String expectedController;
        String actualController = requestUri.getElement(0);
        return actualController == (expectedController = "rest") || actualController != null && actualController.equalsIgnoreCase(expectedController);
    }

    @Override
    public Map<RequestProcessor, String> getDependentRequestProcessors() {
        return this.dependentRequestProcessors;
    }

    public void setDependentRequestProcessors(Map<RequestProcessor, String> precedingRequestProcessors) {
        this.dependentRequestProcessors = precedingRequestProcessors;
    }

    @Override
    public ResponseAction processRequest(RequestUri _requestUri) {
        RestHandler processor = (RestHandler)ServiceLocator.getOptionalBean((String)"restRequestHandler");
        if (processor != null) {
            processor.handle(_requestUri);
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"REST is not attached to application");
        }
        return EMPTY;
    }
}

