/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.requestProcessor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jetbrains.mps.webr.runtime.templateComponent.ActionController;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.BaseApplication;

public class WindowManager
implements Serializable {
    private static final String WINDOW_MANAGER_SESSION_KEY = WindowManager.class.getName() + "_KEY";
    private static final long globalIdBase = (long)Math.random() * 1000000L;
    private static final AtomicLong globalId = new AtomicLong(globalIdBase);
    private static final long serialVersionUID = 42L;
    protected static Log log = LogFactory.getLog(WindowManager.class);
    private final Map<String, ActionController> actionControllers = new ConcurrentHashMap<String, ActionController>(4);

    public String getRequestWindowId() {
        return BaseApplication.getCurrentWindowId();
    }

    public int getActionControllersCount() {
        return this.actionControllers.size();
    }

    public String generateWindowId() {
        for (ActionController controller : this.collectOldActionControllers().values()) {
            controller.destroy();
        }
        String windowId = String.valueOf(globalId.incrementAndGet());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generated new windowId: " + windowId));
        }
        BaseApplication.setCurrentWindowId(windowId);
        return windowId;
    }

    public void destroy() {
        if (ServiceLocator.isInited()) {
            for (ActionController controller : this.actionControllers.values()) {
                controller.destroy();
            }
        }
    }

    public ActionController getActionController(String windowId) {
        return this.actionControllers.get(windowId);
    }

    public ActionController setActionController(String windowId, ActionController controller) {
        return this.actionControllers.put(windowId, controller);
    }

    public void replaceActionController(String windowId, ActionController actionController) {
        ActionController oldActionController = this.getActionController(windowId);
        if (oldActionController != null) {
            oldActionController.exitActionSafe();
        }
        if (actionController != null) {
            this.actionControllers.put(windowId, actionController);
        } else {
            this.actionControllers.remove(windowId);
        }
    }

    public Iterable<ActionController> getActionControllers() {
        return this.actionControllers.values();
    }

    private Map<String, ActionController> collectOldActionControllers() {
        HashMap<String, ActionController> oldActionControllers = new HashMap<String, ActionController>();
        for (Map.Entry<String, ActionController> entry : this.actionControllers.entrySet()) {
            String windowId = entry.getKey();
            ActionController actionController = entry.getValue();
            if (!actionController.isReadyToDie()) continue;
            this.actionControllers.remove(windowId);
            oldActionControllers.put(windowId, actionController);
        }
        return oldActionControllers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WindowManager getWindowManager(HttpSession session) {
        if (session == null) {
            return null;
        }
        try {
            WindowManager windowManager = (WindowManager)session.getAttribute(WINDOW_MANAGER_SESSION_KEY);
            if (windowManager == null) {
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    if (windowManager == null) {
                        windowManager = new WindowManager();
                        session.setAttribute(WINDOW_MANAGER_SESSION_KEY, (Object)windowManager);
                    }
                }
            }
            return windowManager;
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public static WindowManager getWindowManager() {
        HttpServletRequest request = BaseApplication.getRequest();
        if (request == null) {
            return null;
        }
        HttpSession session = request.getSession();
        return WindowManager.getWindowManager(session);
    }

    public static long getTotalActionControllersEverCount() {
        return globalId.get() - globalIdBase;
    }
}

