/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.resource;

import eu.medsea.mimeutil.MimeUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.javascript.runtime.jsDependencies.UrlGetter;
import jetbrains.mps.webr.runtime.requestProcessor.MimeType;
import jetbrains.mps.webr.runtime.resource.ResourceBundle;
import jetbrains.mps.webr.runtime.resource.ResourceBundleId;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import webr.framework.controller.BaseApplication;
import webr.framework.controller.ServletListenerAdapter;
import webr.framework.textBuilder.TBuilderContext;

public class ResourceBundleManager {
    private static ResourceBundleManager instance = new ResourceBundleManager();
    private Map<ResourceBundleId, ResourceBundle> idToBundle = new HashMap<ResourceBundleId, ResourceBundle>();
    private Map<String, ResourceBundle> pathToBundle = new HashMap<String, ResourceBundle>();
    private ThreadLocal<Map<String, ResourceBundleId>> resourceBundleId = new ThreadLocal();

    private ResourceBundleManager() {
        BaseApplication.addListener(new ServletListenerAdapter(){

            @Override
            public void startRequestProcessing(HttpServletRequest request, HttpServletResponse response, GenericServlet servlet) {
                ResourceBundleManager.this.resourceBundleId.remove();
            }

            @Override
            public void finishRequestProcessing() {
                ResourceBundleManager.this.resourceBundleId.remove();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<ResourceBundleId, ResourceBundle> map = this.idToBundle;
        synchronized (map) {
            this.idToBundle = new HashMap<ResourceBundleId, ResourceBundle>();
            this.pathToBundle = new HashMap<String, ResourceBundle>();
        }
    }

    public ResourceBundleId insertResourceBundle(String mimeType, TBuilderContext builderContext) {
        return this.createResourceBundleId(mimeType, builderContext);
    }

    public void addJavascriptResource(UrlGetter getter, TBuilderContext builderContext) {
        this.addResource(getter, builderContext, MimeType.TEXT_JAVASCRIPT.getPresentation());
    }

    public void addCSSResource(UrlGetter getter, TBuilderContext builderContext) {
        this.addResource(getter, builderContext, MimeType.TEXT_CSS.getPresentation());
    }

    public void addResource(UrlGetter resourcePath, TBuilderContext builderContext) {
        this.addResource(resourcePath, builderContext, MimeUtil.getMostSpecificMimeType((Collection)MimeUtil.getMimeTypes((String)resourcePath.getResourcePath())).toString());
    }

    private void addResource(UrlGetter resourcePath, TBuilderContext builderContext, String mimeType) {
        ResourceBundleId rb = this.getResourceBundleId(mimeType);
        if (rb == null) {
            rb = this.insertResourceBundle(mimeType, builderContext);
        }
        rb.add(resourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceBundle getResourceBundle(ResourceBundleId id) {
        Map<ResourceBundleId, ResourceBundle> map = this.idToBundle;
        synchronized (map) {
            ResourceBundle r = this.idToBundle.get(id);
            if (r == null) {
                r = new ResourceBundle(id);
                this.idToBundle.put(id, r);
                this.pathToBundle.put(r.getPath(), r);
            } else if (this.needUpdate()) {
                String oldPath = r.getPath();
                if (r.update()) {
                    this.pathToBundle.remove(oldPath);
                    this.pathToBundle.put(r.getPath(), r);
                }
            }
            return r;
        }
    }

    private boolean needUpdate() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle getResourceBundle(String path) {
        Map<ResourceBundleId, ResourceBundle> map = this.idToBundle;
        synchronized (map) {
            return this.pathToBundle.get(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putResourceBundle(ResourceBundle r) {
        Map<ResourceBundleId, ResourceBundle> map = this.idToBundle;
        synchronized (map) {
            this.pathToBundle.put(r.getPath(), r);
        }
    }

    public ResourceBundleId getJavascriptBundle() {
        return this.getResourceBundleId(MimeType.TEXT_JAVASCRIPT.getPresentation());
    }

    public ResourceBundleId getCSSBundle() {
        return this.getResourceBundleId(MimeType.TEXT_CSS.getPresentation());
    }

    public void flushLink(String mimeType) {
        ResourceBundleId rb = this.getResourceBundleId(mimeType);
        if (rb != null) {
            rb.flushLink();
        }
    }

    public ResourceBundleId getResourceBundleId(String mimeType) {
        Map<String, ResourceBundleId> ids = this.resourceBundleId.get();
        if (ids == null) {
            return null;
        }
        return ids.get(mimeType);
    }

    private ResourceBundleId createResourceBundleId(String mimeType, TBuilderContext builderContext) {
        ResourceBundleId r;
        Map<String, ResourceBundleId> ids = this.resourceBundleId.get();
        if (ids == null) {
            ids = new HashMap<String, ResourceBundleId>();
            this.resourceBundleId.set(ids);
        }
        if ((r = ids.get(mimeType)) == null) {
            r = new ResourceBundleId(mimeType, ResourceBundleManager.check_qe1ti6_b0a0a0d0o((Localizer)ServiceLocator.getOptionalBean((String)"localizer")), builderContext);
            ids.put(mimeType, r);
        }
        return r;
    }

    void removeThreadLocalResourceBundleId(ResourceBundleId id) {
        Map<String, ResourceBundleId> ids = this.resourceBundleId.get();
        if (ids != null) {
            ids.remove(id.getMimeType());
            if (ids.isEmpty()) {
                this.resourceBundleId.remove();
            }
        }
    }

    public static ResourceBundleManager getInstance() {
        return instance;
    }

    private static Locale check_qe1ti6_b0a0a0d0o(Localizer checkedDotOperand) {
        if (null != checkedDotOperand) {
            return checkedDotOperand.getLocale();
        }
        return null;
    }
}

