/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.servlet;

import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.templateComponent.RedirectException;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.mps.webr.runtime.url.RequestUri;
import jetbrains.mps.webr.runtime.util.ApplicationManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import webr.framework.controller.BaseApplication;
import webr.framework.controller.CentralManager;
import webr.framework.controller.ServletListener;
import webr.framework.controller.requestProcessor.RequestProcessor;
import webr.framework.runtime.response.ResponseAction;
import webr.framework.url.UrlUtil;

public abstract class MainServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(MainServlet.class);
    private static final long REQUESTS_PER_SECOND_PERIOD = 5000L;
    public static final String LOG4J_PATH_PARAM = "jetbrains.mps.webr.log4jPath";
    private List<ServletListener> listeners = new ArrayList<ServletListener>();
    private final AtomicLong requestsCount = new AtomicLong(0L);
    private RequestsCountState requestsCountState = new RequestsCountState(System.currentTimeMillis(), 0L, null);

    private void countRequestsPerSecond() {
        RequestsCountState prevRequestsCountState = this.requestsCountState;
        long currentTime = System.currentTimeMillis();
        long currentCount = this.requestsCount.incrementAndGet();
        if (currentTime - prevRequestsCountState.startTime >= 5000L) {
            this.requestsCountState = new RequestsCountState(currentTime, currentCount, prevRequestsCountState);
        }
    }

    @Deprecated
    public static double getRequestsPerSecond() {
        MainServlet servlet = (MainServlet)BaseApplication.getServlet();
        return servlet == null ? 0.0 : servlet.getRequestsThroughput();
    }

    public double getRequestsThroughput() {
        return this.requestsCountState.average;
    }

    @Deprecated
    public CentralManager getCentralManager() {
        return ApplicationManager.getManager();
    }

    public void addListener(ServletListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ServletListener l) {
        this.listeners.remove(l);
    }

    public void notifyListeners(BaseApplication.ListenerVisitor<ServletListener> v) {
        for (ServletListener l : this.listeners) {
            v.visit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.countRequestsPerSecond();
        request.setCharacterEncoding(StandardCharsets.UTF_8.toString());
        String uri = null;
        try {
            uri = UrlUtil.decode(request.getRequestURI(), StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            response.sendError(400, "Requested uri is malformed");
        }
        if (uri != null) {
            String contextAndServletPath = BaseApplication.getFullContextPath(request);
            if (!uri.startsWith(contextAndServletPath)) {
                throw new RuntimeException();
            }
            uri = uri.substring(contextAndServletPath.length());
            RequestUri requestUri = new RequestUri(contextAndServletPath, uri);
            try {
                String debugUri = null;
                boolean infoEnabled = log.isInfoEnabled();
                if (infoEnabled) {
                    String eventName;
                    debugUri = uri + (request.getQueryString() != null ? "?" + request.getQueryString() : "");
                    if ("POST".equals(request.getMethod()) && (eventName = request.getParameter("event_")) != null) {
                        debugUri = debugUri + " [" + eventName + "]";
                    }
                    Thread.currentThread().setName("http request: " + debugUri);
                }
                BaseApplication.startRequestProcessing(request, response, (GenericServlet)this);
                if (infoEnabled) {
                    log.info((Object)("Start processing request " + debugUri));
                }
                Long startRequestProcessingTime = BaseApplication.getStartRequestProcessingTime();
                ResponseAction responseAction = this.processRequest(requestUri);
                if (responseAction == null) {
                    String message = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("jetbrains.mps.webr.runtime.servlet.MainServlet.No_response_action_for_uri_{0}", new Object[]{StringEscapeUtils.escapeHtml((String)uri)});
                    responseAction = ResponseFactory.getInstance().getNotFoundResponse(message);
                    log.error((Object)message);
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Response type: " + responseAction.getClass().getName()));
                }
                this.executeResponseAction(response, responseAction);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Finish processing request %s in %dms", debugUri, System.currentTimeMillis() - startRequestProcessingTime));
                }
            }
            finally {
                BaseApplication.finishRequestProcessing((GenericServlet)this);
                if (log.isInfoEnabled()) {
                    Thread.currentThread().setName("last " + Thread.currentThread().getName());
                }
            }
        }
    }

    protected void executeResponseAction(HttpServletResponse response, ResponseAction responseAction) throws IOException {
        try {
            responseAction.doAction(response);
        }
        catch (Throwable e) {
            if (e instanceof EOFException || e.getCause() instanceof EOFException) {
                log.trace((Object)e, e);
            }
            if (!(e instanceof RedirectException) && !(e.getCause() instanceof RedirectException)) {
                log.error((Object)e, e);
            }
            BaseApplication.setSessionField("POSTPONED_EXCEPTION", e);
            this.getInternalErrorResponse().doAction(response);
        }
    }

    private ResponseAction getInternalErrorResponse() {
        return ResponseFactory.getInstance().getRedirectResponse(UrlUtil.getActionUrl("_InternalErrorThrow", new QueryParameter[0]));
    }

    protected final void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGet(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected String getIndexUri() {
        return null;
    }

    private ResponseAction processRequest(RequestUri requestUri) {
        String indexUri;
        ResponseAction responseAction = null;
        if (("/".equals(requestUri.getShortUri()) || "".equals(requestUri.getShortUri())) && (indexUri = this.getIndexUri()) != null) {
            responseAction = ResponseFactory.getInstance().getRedirectResponse(indexUri);
        }
        if (responseAction == null) {
            for (RequestProcessor requestProcessor : BaseApplication.getCentralManager().getRequestProcessors()) {
                if (!requestProcessor.isApplicable(requestUri)) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Processing with " + requestProcessor));
                }
                try {
                    responseAction = requestProcessor.processRequest(requestUri);
                }
                catch (RuntimeException e) {
                    if (ResponseFactory.isXMLHttpRequest()) {
                        log.error((Object)("Ajax error while processing request with [" + requestProcessor + "]. Redirect to blue screen."), (Throwable)e);
                        BaseApplication.setSessionField("POSTPONED_EXCEPTION", e);
                        return this.getInternalErrorResponse();
                    }
                    throw e;
                }
                if (responseAction == null) continue;
                if (!log.isTraceEnabled()) break;
                log.trace((Object)("Got response from " + requestProcessor));
                break;
            }
        }
        return responseAction;
    }

    protected final void startInit() {
        Thread.currentThread().setName("init servlet");
        BaseApplication.startServletInit((GenericServlet)this);
    }

    protected final void endInit() {
        BaseApplication.finishServletInit((GenericServlet)this);
    }

    protected final void startDestory() {
        Thread.currentThread().setName("destroy servlet");
        BaseApplication.startServletDestroy((GenericServlet)this);
    }

    protected final void endDestroy() {
        BaseApplication.finishServletDestroy();
    }

    private static final class RequestsCountState {
        final long startTime;
        final long startCount;
        final double average;

        private RequestsCountState(long startTime, long startCount, @Nullable RequestsCountState prev) {
            this.startTime = startTime;
            this.startCount = startCount;
            this.average = prev == null ? 0.0 : (double)(startCount - prev.startCount) / (double)(startTime - prev.startTime) * 1000.0;
        }
    }
}

