/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.session;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import jetbrains.mps.webr.runtime.session.WebrSessionListenerImpl;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.BaseApplication;

public class WebrSessionListener
implements HttpSessionListener {
    protected static Log log = LogFactory.getLog(WebrSessionListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent event) {
        boolean wasServletSet = false;
        try {
            HttpSession session = event.getSession();
            if (session != null) {
                ServletContext context = session.getServletContext();
                if (BaseApplication.getServletContext() == null) {
                    BaseApplication.startSessionDestroy(context);
                    wasServletSet = true;
                }
                if (ServiceLocator.isInited()) {
                    WebrSessionListenerImpl impl = WebrSessionListenerImpl.getInstance();
                    impl.sessionDestroyed(session, context);
                }
            }
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Exception while sessionDestroyed", (Throwable)ex);
            }
        }
        finally {
            if (wasServletSet) {
                BaseApplication.finishSessionDestroy();
            }
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        block3: {
            try {
                HttpSession session = event.getSession();
                if (session != null) {
                    ServletContext context = session.getServletContext();
                    WebrSessionListenerImpl impl = WebrSessionListenerImpl.getInstance();
                    impl.sessionCreated(session, context);
                }
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Exception while sessionCreated", (Throwable)ex);
            }
        }
    }
}

