/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.staticHtml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.webr.runtime.staticHtml.GetVariableCommand;
import jetbrains.mps.webr.runtime.staticHtml.HtmlCommand;
import jetbrains.mps.webr.runtime.staticHtml.HtmlElement;
import jetbrains.mps.webr.runtime.staticHtml.IfCommand;
import jetbrains.mps.webr.runtime.staticHtml.IncludeNestedCommand;
import jetbrains.mps.webr.runtime.staticHtml.SetVariableCommand;
import jetbrains.mps.webr.runtime.staticHtml.StaticTemplate;
import jetbrains.mps.webr.runtime.staticHtml.StubCommand;
import jetbrains.mps.webr.runtime.staticHtml.TextElement;

public class HtmlScanner {
    private static List<HtmlCommand> commands = ListSequence.fromListAndArray(new ArrayList(), (Object[])new HtmlCommand[]{new IncludeNestedCommand(), new StubCommand(), new SetVariableCommand(), new GetVariableCommand(), new IfCommand()});
    private static Pattern htmlComment = Pattern.compile("<!--%%\\s*(.*?)\\s*-->");

    public static StaticTemplate scan(String text, Map<String, Object> rootMap) {
        String currentText = text;
        IListSequence elements = ListSequence.fromList(new ArrayList());
        while (currentText.length() != 0) {
            Matcher matcher = htmlComment.matcher(currentText);
            boolean isMatch = matcher.find();
            if (isMatch) {
                int start = matcher.start();
                if (start > 0) {
                    String t1 = currentText.substring(0, start);
                    ListSequence.fromList((List)elements).addElement((Object)new TextElement(t1));
                }
                String comment = matcher.group(1);
                int endIndex = matcher.end();
                String textAfter = currentText.substring(endIndex);
                boolean taken = false;
                for (HtmlCommand command : ListSequence.fromList(commands)) {
                    if (!command.isApplicable(comment)) continue;
                    taken = true;
                    currentText = command.process((List<HtmlElement>)elements, textAfter, rootMap);
                    break;
                }
                if (taken) continue;
                ListSequence.fromList((List)elements).addElement((Object)new TextElement(matcher.group()));
                currentText = textAfter;
                continue;
            }
            ListSequence.fromList((List)elements).addElement((Object)new TextElement(currentText));
            break;
        }
        return new StaticTemplate((List<HtmlElement>)elements);
    }
}

