/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.staticHtml;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.webr.runtime.staticHtml.HtmlCommand;
import jetbrains.mps.webr.runtime.staticHtml.HtmlElement;

class SetVariableCommand
implements HtmlCommand {
    private static Pattern setVariablePattern = Pattern.compile("@\\s*(.*?)\\s*=(.*)");
    private static Pattern stringPattern = Pattern.compile("\\s*\"(.*)\"\\s*");
    private Matcher matcher;

    SetVariableCommand() {
    }

    @Override
    public boolean isApplicable(String comment) {
        this.matcher = setVariablePattern.matcher(comment);
        return this.matcher.matches();
    }

    @Override
    public String process(List<HtmlElement> elements, String textAfter, Map<String, Object> rootMap) {
        MapSequence.fromMap(rootMap).put((Object)this.matcher.group(1), (Object)SetVariableCommand.getObject(this.matcher.group(2)));
        return textAfter;
    }

    private static String getObject(String text) {
        String result = text;
        Matcher matcher = stringPattern.matcher(text);
        boolean isMatch = matcher.find();
        result = isMatch ? matcher.group(1) : result.trim();
        return result;
    }
}

