/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.templateComponent;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.templateComponent.ActionFactory;
import jetbrains.mps.webr.runtime.templateComponent.IdParameter;
import jetbrains.mps.webr.runtime.templateComponent.TemplateComponent;
import jetbrains.mps.webr.runtime.util.ApplicationManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTimeFieldType;
import webr.framework.controller.BaseApplication;
import webr.framework.runtime.response.ResponseAction;
import webr.framework.textBuilder.TBuilderContext;

public abstract class ActionController
implements Serializable {
    protected static Log log = LogFactory.getLog(ActionController.class);
    private final String actionName;
    private final String windowId;
    private Long lastAccess;
    private ActionFactory actionFactory;
    private Map<String, String> actionParameters;
    private IdParameter myIdParameter;

    protected ActionController(String actionName, String windowId, ActionFactory actionFactory) {
        this.actionName = actionName;
        this.windowId = windowId;
        this.actionFactory = actionFactory;
        this.touch();
    }

    protected void touch() {
        this.lastAccess = System.currentTimeMillis();
    }

    protected String[] getActionParameterNames() {
        return new String[0];
    }

    public boolean isReadyToDie() {
        Long deathTime = this.lastAccess + 60000L;
        return DateTimeOperations.compare((Long)deathTime, (CompareType)CompareType.LT, (Long)System.currentTimeMillis(), (DateTimeFieldType)DateTimeFieldType.millisOfSecond());
    }

    public boolean isStreamedOutput() {
        return ApplicationManager.getManager().isStreamedBuilderContext();
    }

    ResponseAction getForbiddenResponse() {
        return ResponseFactory.getInstance().getForbiddenResponse("No access to [" + this.actionName + "]");
    }

    private void saveActionParameters() {
        String value;
        HttpServletRequest request = BaseApplication.getRequest();
        Map<String, String> actionParameters = this.getActionParameters();
        for (String actionParameterName : this.getActionParameterNames()) {
            MapSequence.fromMap(actionParameters).put((Object)actionParameterName, (Object)request.getParameter(actionParameterName));
        }
        IdParameter idParameter = this.getIdParameter();
        if (idParameter != null && (value = idParameter.getValue()) != null && value.length() > 0) {
            MapSequence.fromMap(actionParameters).put((Object)idParameter.getName(), (Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAction enterAction() {
        ActionController actionController = this;
        synchronized (actionController) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Enter to action: " + this.actionName));
            }
            this.saveActionParameters();
            return this.securedRefreshResponse();
        }
    }

    public boolean checkAccess() {
        return this.actionFactory == null || this.actionFactory.hasAccess();
    }

    protected abstract ResponseAction doEnterAction();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAction refreshAction() {
        ActionController actionController = this;
        synchronized (actionController) {
            return this.securedRefreshResponse();
        }
    }

    protected ResponseAction doRefreshAction() {
        return this.doEnterAction();
    }

    public void destroy() {
        this.exitActionSafe();
    }

    public void exitActionSafe() {
        this.exitAction();
    }

    private void exitAction() {
        this.clearSessionVariables(BaseApplication.getSessionFieldMap());
    }

    protected final void clearSessionVariables(Map<String, Serializable> sessionBean) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Clear session variables for windows id [" + this.getWindowId() + "]"));
        }
        BaseApplication.cleanSessionBean(this.getWindowId(), sessionBean);
    }

    public Map<String, String> getActionParameters() {
        if (this.actionParameters == null) {
            this.actionParameters = MapSequence.fromMap(new HashMap());
        }
        return this.actionParameters;
    }

    @Deprecated
    protected TemplateComponent wrapWithLayoutComponent(TemplateComponent nestedTemplateComponent, TBuilderContext builderContext, Map<String, Object> rootMap) {
        return nestedTemplateComponent;
    }

    public String getWindowId() {
        return this.windowId;
    }

    public String getActionName() {
        return this.actionName;
    }

    public boolean isConcurrentAction() {
        return false;
    }

    public boolean isSame(ActionController that) {
        if (that == null) {
            return false;
        }
        return this.getActionName().equals(that.getActionName()) && this.actionFactory == that.actionFactory;
    }

    protected ResponseAction securedRefreshResponse() {
        if (this.checkAccess()) {
            return this.doEnterAction();
        }
        return this.getForbiddenResponse();
    }

    protected IdParameter getIdParameter() {
        return this.myIdParameter;
    }

    protected void setIdParameter(IdParameter value) {
        this.myIdParameter = value;
    }
}

