/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.templateComponent;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.webr.runtime.templateComponent.ActionFactory;

public class ActionFactoryContainer {
    private List<ActionFactory> actionFactories;
    private Map<String, ActionFactory> actionFactoriesMap;

    public void setActionFactories(List<ActionFactory> actionFactories) {
        this.actionFactories = actionFactories;
    }

    public boolean containsFactory(String controllerName) {
        String name = ActionFactoryContainer.getNormalizedName(controllerName);
        return this.getActionFactories().containsKey(name);
    }

    public ActionFactory getFactory(String controllerName) {
        String name = ActionFactoryContainer.getNormalizedName(controllerName);
        return this.getActionFactories().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ActionFactory> getActionFactories() {
        if (this.actionFactoriesMap == null) {
            ActionFactoryContainer actionFactoryContainer = this;
            synchronized (actionFactoryContainer) {
                if (this.actionFactoriesMap == null) {
                    this.actionFactoriesMap = MapSequence.fromMap(new HashMap());
                    for (ActionFactory actionFactory : ListSequence.fromList(this.actionFactories)) {
                        String controllerName = actionFactory.getControllerName();
                        if (controllerName == null || controllerName.length() <= 0) continue;
                        this.actionFactoriesMap.put(ActionFactoryContainer.getNormalizedName(controllerName), actionFactory);
                    }
                }
            }
        }
        return this.actionFactoriesMap;
    }

    private static String getNormalizedName(String name) {
        return name != null ? name.toLowerCase(Locale.US) : null;
    }
}

