/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.templateComponent;

import java.util.Set;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.javascript.runtime.jsDependencies.JsDependencyManager;
import jetbrains.mps.webr.javascript.runtime.jsDependencies.UrlGetter;
import jetbrains.mps.webr.runtime.resource.ResourceBundleManager;
import jetbrains.mps.webr.runtime.templateComponent.LayoutComponent;
import jetbrains.mps.webr.runtime.templateComponent.TemplateComponent;
import jetbrains.mps.webr.runtime.templateComponent.TemplateDependencyManager;
import jetbrains.mps.webr.runtime.util.ApplicationManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import webr.framework.function.HtmlStringUtil;
import webr.framework.textBuilder.TBuilderContext;
import webr.framework.url.DeferredUrl;
import webr.framework.url.UrlUtil;

public class LinkUtil {
    private static boolean DEFER_ENABLED = false;
    public static String DEFER_ATTRIBUTE = "defer";
    public static String DEFER_VALUE = "defer";
    public static String DEFER_STRING = DEFER_ENABLED ? DEFER_ATTRIBUTE + "=\"" + DEFER_VALUE + "\"" : "";

    public static void addInitialScriptDependencies(TBuilderContext builderContext) {
        Tuples._2<String, String> pair = LinkUtil.getLayoutAndRootTemplateNames(builderContext);
        Set<String> deps = ((TemplateDependencyManager)ServiceLocator.getBean((String)"templateDependencyManager")).getSortedDependencies((String)pair._0(), (String)pair._1());
        LinkUtil.addSortedScriptDependencies(builderContext, deps, true);
    }

    public static void addInitialCssDependencies(TBuilderContext builderContext) {
        builderContext.startContentBlock("__CSS__");
        Tuples._2<String, String> pair = LinkUtil.getLayoutAndRootTemplateNames(builderContext);
        Iterable<String> deps = ((TemplateDependencyManager)ServiceLocator.getBean((String)"templateDependencyManager")).getCssDependencies((String)pair._0(), (String)pair._1());
        for (String dep : Sequence.fromIterable(deps)) {
            LinkUtil.addStylesheetLink(builderContext, UrlUtil.getDeferredResourceUri(dep));
        }
        builderContext.endContentBlock();
    }

    public static Tuples._2<String, String> getLayoutAndRootTemplateNames(TBuilderContext builderContext) {
        String templateName;
        String layoutName;
        TemplateComponent rootTemplate = builderContext.getCurrentTemplateComponent().getRootTemplateComponent();
        if (rootTemplate instanceof LayoutComponent) {
            layoutName = rootTemplate.getClass().getName();
            templateName = ((LayoutComponent)rootTemplate).getNestedTemplateComponent().getClass().getName();
        } else {
            layoutName = null;
            templateName = rootTemplate.getClass().getName();
        }
        return MultiTuple.from((Object)layoutName, (Object)templateName);
    }

    public static void addScriptDependencies(TBuilderContext builderContext, Iterable<String> dependencyNames) {
        TemplateComponent template = builderContext.getCurrentTemplateComponent();
        if (template != null && !builderContext.isSkipScriptIncludes()) {
            Set<String> exceptJsRoots = template.getJsDependencies();
            Set sortedDepenedencies = ((JsDependencyManager)ServiceLocator.getBean((String)"jsDependencyManager")).sortDependencies(dependencyNames, exceptJsRoots);
            LinkUtil.addSortedScriptDependencies(builderContext, sortedDepenedencies, false);
        }
    }

    public static void addDynamicTemplateScriptDependencies(TBuilderContext builderContext, String templateName) {
        TemplateComponent template = builderContext.getCurrentTemplateComponent();
        if (template != null && !builderContext.isSkipScriptIncludes() && builderContext.addDynamicallyIncludedTemplate(templateName)) {
            Tuples._2<String, String> pair = LinkUtil.getLayoutAndRootTemplateNames(builderContext);
            Set<String> exceptJsRoots = template.getJsDependencies();
            IListSequence dependencyNames = Sequence.fromIterable(((TemplateDependencyManager)ServiceLocator.getBean((String)"templateDependencyManager")).getDynamicDependencies((String)pair._0(), (String)pair._1(), ((TemplateDependencyManager)ServiceLocator.getBean((String)"templateDependencyManager")).getTemplateClassName(templateName))).subtract(Sequence.fromIterable(exceptJsRoots)).toListSequence();
            LinkUtil.addSortedScriptDependencies(builderContext, (Iterable<String>)dependencyNames, false);
        }
    }

    private static boolean addSortedScriptDependencies(TBuilderContext builderContext, Iterable<String> sortedDepenedencies, boolean bundleIfPossible) {
        boolean bundled;
        builderContext.getCurrentTemplateComponent().addJsDependencies(sortedDepenedencies);
        if (bundleIfPossible && LinkUtil.useResourceBundle()) {
            Iterable resourcePaths = ((JsDependencyManager)ServiceLocator.getBean((String)"jsDependencyManager")).toUrlGetters(sortedDepenedencies);
            builderContext.startContentBlock("__JAVASCRIPT__");
            for (UrlGetter resourcePath : Sequence.fromIterable((Iterable)resourcePaths)) {
                ResourceBundleManager.getInstance().addJavascriptResource(resourcePath, builderContext);
            }
            builderContext.endContentBlock();
            bundled = true;
        } else {
            Iterable urls = ((JsDependencyManager)ServiceLocator.getBean((String)"jsDependencyManager")).toUrls(sortedDepenedencies);
            for (String url : Sequence.fromIterable((Iterable)urls)) {
                builderContext.appendIndent();
                builderContext.append("<script type=\"text/javascript\" src=\"");
                builderContext.append(HtmlStringUtil.html(url));
                builderContext.append("\"");
                builderContext.append(DEFER_STRING);
                builderContext.append("></script>");
                builderContext.appendNewLine();
            }
            bundled = false;
        }
        return bundled;
    }

    public static void addStylesheetLink(TBuilderContext builderContext, DeferredUrl deferred) {
        if (LinkUtil.useResourceBundle()) {
            ResourceBundleManager.getInstance().addCSSResource(deferred, builderContext);
        } else {
            builderContext.appendIndent();
            builderContext.append("<link type=\"text/css\" media=\"all\" rel=\"stylesheet\" href=\"");
            builderContext.append(HtmlStringUtil.html(deferred.getUrl()));
            builderContext.append("\"/>");
            builderContext.appendNewLine();
        }
    }

    public static void addRssLink(TBuilderContext builderContext, String url) {
        LinkUtil.addRssLink(builderContext, url, null);
    }

    public static void addRssLink(TBuilderContext builderContext, String url, String title) {
        builderContext.appendIndent();
        builderContext.append("<link rel=\"alternate\" type=\"application/rss+xml\"");
        if (title != null && title.length() > 0) {
            builderContext.append(" title=\"");
            builderContext.append(HtmlStringUtil.html(title));
            builderContext.append("\"");
        }
        builderContext.append(" href=\"");
        builderContext.append(HtmlStringUtil.html(url));
        builderContext.append("\"/>");
        builderContext.appendNewLine();
    }

    public static boolean useResourceBundle() {
        return !ApplicationManager.isDebugMode();
    }

    public static void insertLinkToBundle(String mimeType) {
        if (LinkUtil.useResourceBundle()) {
            ResourceBundleManager.getInstance().flushLink(mimeType);
        }
    }
}

