/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.templateComponent;

import com.jetbrains.teamsys.dnq.database.TransientStoreUtil;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.EntityRemovedInDatabaseException;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.templateComponent.ActionController;
import jetbrains.mps.webr.runtime.templateComponent.ActionFactory;
import jetbrains.mps.webr.runtime.templateComponent.IThreadSorter;
import jetbrains.mps.webr.runtime.templateComponent.LayoutComponent;
import jetbrains.mps.webr.runtime.templateComponent.TemplateActionControllerTimer;
import jetbrains.mps.webr.runtime.templateComponent.TemplateComponent;
import jetbrains.mps.webr.runtime.templateComponent.ThreadSorterFair;
import jetbrains.mps.webr.runtime.templateComponent.ThreadSorterFairSemaphore;
import jetbrains.mps.webr.runtime.templateComponent.ThreadSorterFake;
import jetbrains.mps.webr.userManagement.runtime.SecurityNavigator;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.BaseApplication;
import webr.framework.controller.ControllerOperations;
import webr.framework.runtime.response.ResponseAction;
import webr.framework.textBuilder.PopulateParameters;
import webr.framework.textBuilder.StreamBuilderContext;
import webr.framework.textBuilder.TBuilderContext;

public abstract class TemplateActionController
extends ActionController {
    private static final boolean fakeThreadSorter = Boolean.getBoolean("jetbrains.webr.fakeThreadSorter");
    private static final boolean fairThreadSorter = Boolean.getBoolean("jetbrains.webr.fairThreadSorter");
    private static final int destroyControllerRetryTimeout = 1000;
    private static final ThreadLocal<Boolean> wasTransactionException = new ThreadLocal();
    protected static Log log = LogFactory.getLog(TemplateActionController.class);
    private final IThreadSorter threadSorter = fakeThreadSorter ? new ThreadSorterFake() : (fairThreadSorter ? new ThreadSorterFair() : new ThreadSorterFairSemaphore());
    protected TemplateComponent rootTemplateComponent;
    private boolean deferredCommandsPrebuilding;
    private boolean rootWasRebuilt;
    private boolean transactional = true;
    private boolean readonly = false;

    public TemplateActionController(String actionName, String windowId, ActionFactory actionFactory) {
        super(actionName, windowId, actionFactory);
    }

    public TemplateActionController(String actionName, String windowId, ActionFactory actionFactory, boolean transactional) {
        this(actionName, windowId, actionFactory);
        this.transactional = transactional;
    }

    @Override
    protected ResponseAction doEnterAction() {
        return this.getRootTemplateRenderResponseAction(true);
    }

    @Override
    protected ResponseAction doRefreshAction() {
        return this.getRootTemplateRenderResponseAction(false);
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @Deprecated
    public boolean hasAccess(Map<String, Object> rootMap, TBuilderContext builderContext) {
        return true;
    }

    @Deprecated
    public void fillParameters(Map<String, Object> templateParameters, TBuilderContext builderContext) {
    }

    private ResponseAction getRootTemplateRenderResponseAction(boolean firstRendering) {
        this.beginResponse(false);
        try {
            String currentTemplateName;
            String currentLayoutName;
            TBuilderContext builderContext = StreamBuilderContext.create(this.isStreamedOutput());
            builderContext.setWindowId(this.getWindowId());
            if (firstRendering) {
                try {
                    this.rootTemplateComponent = this.createTemplateComponent(builderContext);
                }
                catch (EntityRemovedInDatabaseException e) {
                    return TemplateComponent.redirectToRemovedOnRender(e, this.getActionParameters(), this);
                }
                if (this.rootTemplateComponent == null) {
                    this.endResponse();
                    return this.getForbiddenResponse();
                }
            }
            if (this.rootTemplateComponent instanceof LayoutComponent) {
                LayoutComponent layoutComponent = (LayoutComponent)this.rootTemplateComponent;
                currentLayoutName = layoutComponent.getTemplateName();
                currentTemplateName = layoutComponent.getNestedTemplateComponent().getTemplateName();
            } else {
                currentLayoutName = null;
                currentTemplateName = this.rootTemplateComponent.getTemplateName();
            }
            builderContext.setCurrentTemplateName(currentTemplateName);
            builderContext.setCurrentLayoutName(currentLayoutName);
            ResponseAction responseAction = ResponseFactory.getInstance().getHtmlRenderResponseAction(this.rootTemplateComponent, builderContext, new _FunctionTypes._void_P0_E0(){

                public void invoke() {
                    TemplateActionController.this.endResponse();
                }
            });
            return responseAction;
        }
        catch (RuntimeException e) {
            this.endResponse();
            throw e;
        }
    }

    public abstract TemplateComponent createTemplateComponent(TBuilderContext var1);

    public boolean allowAnonymous() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAction handleEvent(String eventSource, String eventName) {
        this.beginResponse(true);
        try {
            ResponseAction responseAction = this.handleEventImpl(eventSource, eventName);
            return responseAction;
        }
        finally {
            this.endResponse();
        }
    }

    protected ResponseAction handleEventImpl(String eventSource, String eventName) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Handle event [" + eventName + "] in action [" + this.getActionName() + "]"));
        }
        HttpServletRequest request = BaseApplication.getRequest();
        HttpSession originalSession = request.getSession();
        ResponseAction responseAction = null;
        try {
            TransientStoreSession tran;
            responseAction = this.rootTemplateComponent.newHandleEvent(eventName, new PopulateParameters(request));
            if (responseAction == null) {
                responseAction = this.doHandleEvent(eventSource, eventName);
            }
            if (this.transactional && (tran = DnqUtils.getCurrentTransientSession()) != null && tran.isOpened() && !tran.isReadonly()) {
                tran.flush();
            }
            if (request.getSession() != originalSession) {
                return ((SecurityNavigator)ServiceLocator.getBean((String)"securityNavigator")).getLogoutResponseAction();
            }
        }
        catch (Throwable e) {
            wasTransactionException.set(true);
            this.handleEventException(e);
        }
        try {
            this.processAjaxCommand();
        }
        catch (Throwable e) {
            wasTransactionException.set(true);
            this.handleEventException(e);
        }
        if (responseAction == null && BaseApplication.getCompositeCommand().isEmpty()) {
            responseAction = ControllerOperations.getDefaultResponseAction();
        }
        return responseAction;
    }

    protected void handleEventException(Throwable e) {
        if (this.rootTemplateComponent instanceof LayoutComponent) {
            ((LayoutComponent)this.rootTemplateComponent).getNestedTemplateComponent().handleEventException(e, this.transactional);
        } else {
            this.rootTemplateComponent.handleEventException(e, this.transactional);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAjaxCommand() {
        this.rootWasRebuilt = false;
        if (!this.deferredCommandsPrebuilding) {
            try {
                this.deferredCommandsPrebuilding = true;
                this.rootTemplateComponent.prebuildCompositeCommandsContent(this);
            }
            finally {
                this.deferredCommandsPrebuilding = false;
            }
        } else {
            throw new IllegalStateException("Flag for deferredCommands prebuild was already set.");
        }
    }

    protected boolean isDeferredCommandsPrebuilding() {
        return this.deferredCommandsPrebuilding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildRootIfNeeded() {
        if (!this.rootWasRebuilt) {
            try {
                this.getRootTemplateComponent(true).rebuildRootComponent();
            }
            finally {
                this.rootWasRebuilt = true;
            }
        }
    }

    protected ResponseAction doHandleEvent(String eventSource, String eventName) {
        if ("_heart_beat".equals(eventName)) {
            this.touch();
            return ResponseFactory.getJsResponseFactory().getDefaultResponse();
        }
        return null;
    }

    public TemplateComponent getRootTemplateComponent(boolean unwrapLayout) {
        TemplateComponent result = this.rootTemplateComponent;
        if (unwrapLayout && result instanceof LayoutComponent) {
            LayoutComponent layout = (LayoutComponent)result;
            result = layout.getNestedTemplateComponent();
        }
        return result;
    }

    @Override
    public void destroy() {
        final Map<String, Serializable> sessionBean = BaseApplication.getSessionFieldMap();
        if (!this.tryExitSafeWithTimeout(1000, sessionBean)) {
            TemplateActionControllerTimer.getInstance().queueIn(new Job(){

                protected void execute() throws Throwable {
                    block3: {
                        try {
                            if (!TemplateActionController.this.tryExitSafeWithTimeout(1000, sessionBean)) {
                                TemplateActionControllerTimer.getInstance().queueIn((Job)this, 1000L);
                            }
                        }
                        catch (Exception e) {
                            if (!log.isWarnEnabled()) break block3;
                            log.warn((Object)"Exception while while exitActionSafe.", (Throwable)e);
                        }
                    }
                }

                public String getName() {
                    return "Destroy template action controller";
                }
            }, 10L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitActionSafe() {
        this.beginResponse(false);
        try {
            this.doExitActionSafe(BaseApplication.getSessionFieldMap());
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExitActionSafe(Map<String, Serializable> sessionBean) throws IllegalStateException {
        TemplateActionController templateActionController = this;
        synchronized (templateActionController) {
            if (this.rootTemplateComponent != null) {
                this.rootTemplateComponent.destroy();
            }
        }
        this.clearSessionVariables(sessionBean);
    }

    private boolean tryExitSafeWithTimeout(int timeout, final Map<String, Serializable> sessionBean) {
        block3: {
            try {
                if (this.beginResponseNoTransaction(timeout)) {
                    wasTransactionException.set(false);
                    return (Boolean)_Txn.evalNew((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<Boolean>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Boolean invoke() {
                            try {
                                TemplateActionController.this.doExitActionSafe(sessionBean);
                                Boolean bl = true;
                                return bl;
                            }
                            finally {
                                TemplateActionController.this.endResponse();
                            }
                        }
                    });
                }
            }
            catch (IllegalStateException e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)"Timeout while trying to perform exitActionSafe(). Retry to exit later", (Throwable)e);
            }
        }
        return false;
    }

    private boolean beginResponseNoTransaction(long timeout) {
        return this.threadSorter.tryStartCurrentThreadSorted(timeout);
    }

    private void beginResponse(boolean canWrite) {
        this.threadSorter.startCurrentThreadSorted();
        if (this.transactional) {
            wasTransactionException.set(false);
            TransientStoreSession session = DnqUtils.getCurrentTransientSession();
            if (session != null) {
                TransientStoreUtil.abort((TransientStoreSession)session);
            }
            if (this.isReadonly() && !canWrite) {
                DnqUtils.beginReadonlyTransientSession();
            } else {
                DnqUtils.beginTransientSession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endResponse() {
        block7: {
            try {
                TransientStoreSession session;
                if (!this.transactional || (session = DnqUtils.getCurrentTransientSession()) == null || !session.isOpened()) break block7;
                try {
                    if (!wasTransactionException.get().booleanValue() && !session.isReadonly()) {
                        session.commit();
                    }
                }
                finally {
                    TransientStoreUtil.abort((TransientStoreSession)session);
                }
            }
            finally {
                this.threadSorter.finishCurrentThread();
            }
        }
    }
}

