/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.templateComponent;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import jetbrains.mps.webr.runtime.templateComponent.IThreadSorter;

public class ThreadSorterFairSemaphore
implements IThreadSorter {
    private static final int TIMEOUT = Integer.getInteger("jetbrains.webr.fairSemaphoreThreadSorterTimeout", 60000);
    private final Semaphore semaphore = new Semaphore(1, true);

    @Override
    public void startCurrentThreadSorted() {
        if (!this.tryStartCurrentThreadSorted(TIMEOUT)) {
            throw new RuntimeException("ThreadSorterFairSemaphore timeout after " + TIMEOUT + " ms. Deadlock is likely.");
        }
    }

    @Override
    public boolean tryStartCurrentThreadSorted(long timeout) {
        try {
            return this.semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    @Override
    public void finishCurrentThread() {
        this.semaphore.release();
    }
}

