/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.uri;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public final class Path {
    private final List<String> myPathElements;
    private final String myExtension;
    private String myShortName;

    private Path(List<String> pathElements, String shortName, String extension) {
        this.myPathElements = pathElements;
        this.myShortName = shortName;
        this.myExtension = extension;
    }

    public String getShortName() {
        return this.myShortName;
    }

    public void setShortName(String shortName) {
        this.myShortName = shortName;
    }

    public void appendToShortName(String shortNameSuffix) {
        this.myShortName = this.myShortName + shortNameSuffix;
    }

    public String toPathStr() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String pathElement : this.myPathElements) {
            stringBuilder.append(pathElement);
            stringBuilder.append("/");
        }
        stringBuilder.append(this.myShortName);
        stringBuilder.append(".");
        stringBuilder.append(this.myExtension);
        return stringBuilder.toString();
    }

    public static Path newPath(String pathStr) {
        pathStr = StringUtils.defaultString((String)pathStr);
        String[] strings = pathStr.split("/");
        ArrayList<String> pathElements = new ArrayList<String>();
        int len = strings.length;
        for (int i = 0; i < len - 1; ++i) {
            pathElements.add(strings[i]);
        }
        String fileName = strings[len - 1];
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            throw new IllegalArgumentException("Can't create path from string [" + pathStr + "]");
        }
        String shortName = fileName.substring(0, index);
        String extension = fileName.substring(index + 1);
        return new Path(pathElements, shortName, extension);
    }
}

