/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.controller;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.mps.webr.runtime.converter.TypeConvertManager;
import jetbrains.mps.webr.runtime.servlet.MainServlet;
import jetbrains.mps.webr.runtime.util.ApplicationManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import webr.framework.controller.CentralManager;
import webr.framework.controller.ServletListener;
import webr.framework.runtime.response.JsCompositeCommandResponse;

public final class BaseApplication {
    private static final Log log = LogFactory.getLog(BaseApplication.class);
    private static final String SESSION_VARIABLES = BaseApplication.class.getName() + "SESSION_VARIABLES";
    private static ThreadLocal<HttpServletRequest> myRequest = new ThreadLocal();
    private static ThreadLocal<Long> myStartRequestProcessingTime = new ThreadLocal();
    private static ThreadLocal<HttpServletResponse> myResponse = new ThreadLocal();
    private static final ThreadLocal<Boolean> isStreamedOutput = new ThreadLocal();
    private static ThreadLocal<GenericServlet> myServlet = new ThreadLocal();
    private static ThreadLocal<ServletContext> myServletContext = new ThreadLocal();
    private static ThreadLocal<String> myCurrentWindowId = new ThreadLocal();
    private static ThreadLocal<JsCompositeCommandResponse> myCompositeCommand = new ThreadLocal();
    private static List<ServletListener> LISTENERS = new ArrayList<ServletListener>();

    private BaseApplication() {
    }

    public static boolean isInsideRequestProcessing() {
        return myRequest.get() != null;
    }

    public static void startServletInit(final GenericServlet servlet) {
        myServlet.set(servlet);
        BaseApplication.setServletContext(servlet.getServletContext());
        BaseApplication.notifyListeners(new ListenerVisitor<ServletListener>(){

            @Override
            public void visit(ServletListener l) {
                l.beforeServletInit(servlet);
            }
        }, servlet);
    }

    public static void finishServletInit(GenericServlet servlet) {
        BaseApplication.notifyListeners(new ListenerVisitor<ServletListener>(){

            @Override
            public void visit(ServletListener l) {
                l.afterServletInit();
            }
        }, servlet);
        myServlet.remove();
        BaseApplication.setServletContext(null);
    }

    public static void startServletDestroy(final GenericServlet servlet) {
        myServlet.set(servlet);
        BaseApplication.setServletContext(servlet.getServletContext());
        BaseApplication.notifyListeners(new ListenerVisitor<ServletListener>(){

            @Override
            public void visit(ServletListener l) {
                l.beforeServletDestroy(servlet);
            }
        }, servlet);
    }

    public static void finishServletDestroy() {
        BaseApplication.notifyListeners(new ListenerVisitor<ServletListener>(){

            @Override
            public void visit(ServletListener l) {
                l.afterServleDestroy();
            }
        }, myServlet.get());
        myServlet.remove();
        BaseApplication.setServletContext(null);
    }

    public static void startRequestProcessing(final HttpServletRequest request, final HttpServletResponse response, final GenericServlet servlet) {
        myServlet.set(servlet);
        BaseApplication.setRequest(request);
        BaseApplication.setServletContext(servlet.getServletContext());
        BaseApplication.setStartRequestProcessingTime(System.currentTimeMillis());
        BaseApplication.setResponse(response);
        myCurrentWindowId.remove();
        myCompositeCommand.set(new JsCompositeCommandResponse());
        BaseApplication.notifyListeners(new ListenerVisitor<ServletListener>(){

            @Override
            public void visit(ServletListener l) {
                l.startRequestProcessing(request, response, servlet);
            }
        }, servlet);
    }

    public static void finishRequestProcessing(GenericServlet servlet) {
        BaseApplication.notifyListeners(new ListenerVisitor<ServletListener>(){

            @Override
            public void visit(ServletListener l) {
                l.finishRequestProcessing();
            }
        }, servlet);
        isStreamedOutput.remove();
        BaseApplication.setRequest(null);
        BaseApplication.setServletContext(null);
        BaseApplication.setStartRequestProcessingTime(null);
        BaseApplication.setResponse(null);
        myCurrentWindowId.remove();
        myCompositeCommand.remove();
    }

    public static void setResponse(HttpServletResponse response) {
        if (response == null) {
            myResponse.remove();
        } else {
            myResponse.set(response);
        }
    }

    public static void setStartRequestProcessingTime(Long value) {
        if (value == null) {
            myStartRequestProcessingTime.remove();
        } else {
            myStartRequestProcessingTime.set(value);
        }
    }

    public static void setServletContext(ServletContext servletContext) {
        if (servletContext == null) {
            myServletContext.remove();
        } else {
            myServletContext.set(servletContext);
        }
    }

    public static ClassLoader getContextClassLoader() {
        GenericServlet servlet = myServlet.get();
        if (servlet != null) {
            return servlet.getClass().getClassLoader();
        }
        return BaseApplication.class.getClassLoader();
    }

    public static void startSessionDestroy(ServletContext servletContext) {
        BaseApplication.setServletContext(servletContext);
    }

    public static void finishSessionDestroy() {
        BaseApplication.setServletContext(null);
    }

    private static void notifyListeners(ListenerVisitor<ServletListener> v, GenericServlet servlet) {
        for (ServletListener l : LISTENERS) {
            v.visit(l);
        }
        if (servlet instanceof MainServlet) {
            ((MainServlet)servlet).notifyListeners(v);
        }
    }

    public static void addListener(ServletListener l) {
        LISTENERS.add(l);
    }

    public static void removeListener(ServletListener l) {
        LISTENERS.remove(l);
    }

    @Deprecated
    public static GenericServlet getServlet() {
        return myServlet.get();
    }

    public static ServletContext getServletContext() {
        return myServletContext.get();
    }

    public static void setRequest(HttpServletRequest request) {
        if (request == null) {
            myRequest.remove();
        } else {
            myRequest.set(request);
        }
    }

    public static void setStreamedOutput() {
        isStreamedOutput.set(true);
    }

    public static boolean getStreamedOutput() {
        Boolean result = isStreamedOutput.get();
        return result != null && result != false;
    }

    public static HttpServletRequest getRequest() {
        return myRequest.get();
    }

    public static String getFullContextPath() {
        return BaseApplication.getFullContextPath(BaseApplication.getRequest());
    }

    public static String getFullContextPath(HttpServletRequest request) {
        return request.getContextPath() + request.getServletPath();
    }

    public static Long getStartRequestProcessingTime() {
        return myStartRequestProcessingTime.get();
    }

    @Nullable
    public static StringBuilder getDefaultBaseURL() {
        HttpServletRequest request = BaseApplication.getRequest();
        if (request == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Is not inside servlet request processing.");
            }
            return null;
        }
        StringBuilder url = new StringBuilder(48);
        String scheme = request.getScheme();
        int port = request.getServerPort();
        url.append(scheme);
        url.append("://");
        url.append(request.getServerName());
        if (port > 0 && (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443)) {
            url.append(':');
            url.append(port);
        }
        url.append(request.getContextPath());
        return url;
    }

    public static HttpServletResponse getResponse() {
        return myResponse.get();
    }

    public static CentralManager getCentralManager() {
        return (CentralManager)ServiceLocator.getBean((String)"centralManager");
    }

    public static JsCompositeCommandResponse getCompositeCommand() {
        return myCompositeCommand.get();
    }

    public static <T> T getSessionField(String name, boolean global) {
        if (!global) {
            name = BaseApplication.getPerWindowSessionParamName(name);
        }
        return BaseApplication.getSessionField(name);
    }

    private static <T> String getPerWindowSessionParamName(String name) {
        return BaseApplication.getWindowPrefix(BaseApplication.getCurrentWindowId()) + "-" + name;
    }

    private static <T> String getWindowPrefix(String windowId) {
        return "$" + windowId + "$";
    }

    @Deprecated
    public static void clearSessionFieldsForWindowId(String windowId) {
        BaseApplication.cleanSessionBean(windowId, BaseApplication.getSessionFieldMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanSessionBean(String windowId, Map<String, Serializable> sessionBean) {
        if (sessionBean == null) {
            return;
        }
        Map<String, Serializable> map = sessionBean;
        synchronized (map) {
            String prefix = BaseApplication.getWindowPrefix(windowId);
            for (String key : new HashSet<String>(sessionBean.keySet())) {
                if (!key.startsWith(prefix)) continue;
                sessionBean.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getSessionField(String name, HttpSession httpSession) {
        Map<String, Serializable> sessionBean = BaseApplication.getSessionBean(httpSession);
        if (sessionBean == null) {
            return null;
        }
        Map<String, Serializable> map = sessionBean;
        synchronized (map) {
            if (sessionBean.containsKey(name)) {
                Serializable value = sessionBean.get(name);
                if (value instanceof AsStringWrapper) {
                    AsStringWrapper handler = (AsStringWrapper)value;
                    return (T)handler.getValue();
                }
                if (value instanceof EntityId) {
                    TransientStoreSession dbSession = DnqUtils.getCurrentTransientSession();
                    if (dbSession == null) {
                        throw new IllegalStateException("No current transient session.");
                    }
                    return (T)dbSession.getEntity((EntityId)value);
                }
                return (T)value;
            }
            Object initialValue = null;
            if (BaseApplication.getCentralManager().getSessionVariableInitializers().containsKey(name)) {
                initialValue = BaseApplication.getCentralManager().getSessionVariableInitializers().get(name).getInitialValue();
            }
            BaseApplication.setSessionField(name, initialValue);
            return (T)initialValue;
        }
    }

    public static <T> T getSessionField(String name) {
        if (!BaseApplication.isInsideRequestProcessing()) {
            return null;
        }
        return BaseApplication.getSessionField(name, BaseApplication.getRequest().getSession(false));
    }

    public static <T> T setSessionField(String name, T value, boolean global) {
        if (!global) {
            name = BaseApplication.getPerWindowSessionParamName(name);
        }
        return BaseApplication.setSessionField(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T setSessionField(String name, T value) {
        Map<String, Serializable> sessionBean = BaseApplication.getSessionFieldMap();
        if (sessionBean == null) {
            return null;
        }
        Map<String, Serializable> map = sessionBean;
        synchronized (map) {
            if (value == null) {
                sessionBean.put(name, null);
            } else if (value instanceof Serializable) {
                sessionBean.put(name, (Serializable)value);
            } else if (value instanceof Entity) {
                sessionBean.put(name, (Serializable)((Entity)value).getId());
            } else {
                sessionBean.put(name, new AsStringWrapper(value));
            }
        }
        return value;
    }

    public static Object getCookieField(String name, String className) {
        Cookie cookie = BaseApplication.findCookie(name);
        if (cookie == null) {
            return null;
        }
        String value = cookie.getValue();
        try {
            byte[] bytes = value.getBytes();
            byte[] decoded = Base64.decodeBase64((byte[])bytes);
            value = new String(decoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return ApplicationManager.getManager().fromIdString(value, className);
    }

    public static <T> T setCookieField(String name, T value) {
        return BaseApplication.setCookieField(name, value, null);
    }

    public static <T> T setCookieField(String name, T value, String domainPattern) {
        Cookie cookie = BaseApplication.findCookie(name);
        if (value != null) {
            String stringValue = ApplicationManager.getManager().toIdString(value);
            try {
                byte[] bytes = stringValue.getBytes("UTF-8");
                stringValue = Base64.encodeBase64URLSafeString((byte[])bytes);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            if (cookie == null) {
                cookie = new Cookie(name, stringValue);
            } else {
                cookie.setValue(stringValue);
            }
            cookie.setMaxAge(31536000);
        } else if (cookie != null) {
            cookie.setMaxAge(0);
            cookie.setValue(null);
        }
        if (cookie != null) {
            String path;
            if (domainPattern != null) {
                cookie.setDomain(domainPattern);
            }
            cookie.setPath((path = BaseApplication.getFullContextPath()).isEmpty() ? "/" : path);
            cookie.setVersion(0);
            myResponse.get().addCookie(cookie);
        }
        return value;
    }

    public static String getCurrentWindowId() {
        if (BaseApplication.isInsideRequestProcessing()) {
            String currentWindowId = myCurrentWindowId.get();
            if (currentWindowId == null) {
                currentWindowId = BaseApplication.getRequest().getParameter("window_id");
                myCurrentWindowId.set(currentWindowId);
            }
            return currentWindowId;
        }
        return null;
    }

    public static void setCurrentWindowId(String currentWindowId) {
        myCurrentWindowId.set(currentWindowId);
    }

    public static Map<String, Serializable> getSessionFieldMap() {
        HttpServletRequest servletRequest = BaseApplication.getRequest();
        if (servletRequest == null) {
            return null;
        }
        HttpSession session = servletRequest.getSession();
        Map<String, Serializable> sessionBean = BaseApplication.getSessionBean(session);
        if (sessionBean == null) {
            sessionBean = new HashMap<String, Serializable>();
            BaseApplication.setSessionBean(session, sessionBean);
        }
        return sessionBean;
    }

    public static Map<String, Serializable> getSessionBean(HttpSession session) {
        return session == null ? null : (Map)session.getAttribute(SESSION_VARIABLES);
    }

    public static void setSessionBean(HttpSession session, Map<String, Serializable> bean) {
        try {
            session.setAttribute(SESSION_VARIABLES, bean);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Cookie findCookie(String name) {
        Cookie cookie = null;
        Cookie[] cookies = myRequest.get().getCookies();
        if (cookies != null) {
            for (Cookie cur : cookies) {
                if (!cur.getName().equals(name)) continue;
                cookie = cur;
            }
        }
        return cookie;
    }

    public static interface ListenerVisitor<T> {
        public void visit(T var1);
    }

    private static class AsStringWrapper
    implements Serializable {
        private String myTypeName;
        private String myValueAsString;

        public AsStringWrapper(@NotNull Object value) {
            TypeConvertManager typeConvertManager = BaseApplication.getCentralManager().getTypeConvertManager();
            this.myValueAsString = typeConvertManager.toString(value);
            this.myTypeName = value.getClass().getName();
        }

        public Object getValue() {
            TypeConvertManager typeConvertManager = BaseApplication.getCentralManager().getTypeConvertManager();
            return typeConvertManager.fromString(this.myValueAsString, this.myTypeName);
        }
    }
}

