/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.controller;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jetbrains.exodus.util.StringInterner;
import jetbrains.mps.webr.runtime.converter.ConvertException;
import jetbrains.mps.webr.runtime.requestProcessor.FileUploadRequestProcessor;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.BaseApplication;
import webr.framework.controller.exception.EventParameterException;
import webr.framework.controller.exception.LabeledInputException;
import webr.framework.runtime.response.ResponseAction;
import webr.framework.url.UrlUtil;

public final class ControllerOperations {
    private static final Log log = LogFactory.getLog(ControllerOperations.class);

    private ControllerOperations() {
    }

    public static String getEventName() {
        HttpServletRequest servletRequest = BaseApplication.getRequest();
        String eventName = null;
        if (servletRequest != null) {
            eventName = servletRequest.getParameter("event_");
        }
        if (eventName == null) {
            eventName = "not found";
        }
        return StringInterner.intern((String)eventName);
    }

    public static <T> T getEventParameter(String parameterName, Class<T> parameterType) {
        Object param = ControllerOperations.getAttribute(parameterName);
        if (param != null) {
            return (T)param;
        }
        String valueAsString = ControllerOperations.getParameter(parameterName);
        try {
            return (T)BaseApplication.getCentralManager().getTypeConvertManager().fromString(valueAsString, parameterType.getName());
        }
        catch (ConvertException e) {
            throw new EventParameterException("Parameter [" + parameterName + "] has incorrect format", e, parameterName, parameterType.getName(), valueAsString);
        }
    }

    public static <T> T getLabeledInputValue(String name, Class<T> parameterType) {
        if (DiskFileItem.class.isAssignableFrom(parameterType)) {
            return (T)FileUploadRequestProcessor.getFileItem(name);
        }
        String valueAsString = ControllerOperations.getParameter(name);
        String parameterTypeName = parameterType.getName();
        try {
            return (T)BaseApplication.getCentralManager().fromIdString(valueAsString, parameterTypeName);
        }
        catch (ConvertException e) {
            throw new LabeledInputException(e, name);
        }
    }

    public static <T> List<T> getLabeledInputValues(String name, Class<T> parameterType, boolean commaSeparatedValues) {
        String[] valuesAsString;
        ArrayList<Object> result = new ArrayList<Object>();
        String parameterTypeName = parameterType.getName();
        if (!commaSeparatedValues) {
            valuesAsString = ControllerOperations.getParameterValues(name);
            if (valuesAsString == null) {
                return result;
            }
        } else {
            String valueAsCommaSeparatedString = ControllerOperations.getParameter(name);
            if (valueAsCommaSeparatedString == null) {
                return result;
            }
            valuesAsString = valueAsCommaSeparatedString.split(",");
        }
        for (String value : valuesAsString) {
            try {
                Object v = BaseApplication.getCentralManager().fromIdString(value, parameterTypeName);
                if (v == null) continue;
                result.add(v);
            }
            catch (ConvertException e) {
                throw new LabeledInputException(e, name);
            }
        }
        return result;
    }

    static String getParameter(String parameterName) {
        return StringInterner.intern((String)BaseApplication.getRequest().getParameter(parameterName));
    }

    static Object getAttribute(String parameterName) {
        return BaseApplication.getRequest().getAttribute(parameterName);
    }

    static String[] getParameterValues(String parameterName) {
        return BaseApplication.getRequest().getParameterValues(parameterName);
    }

    public static String getEventSource() {
        String eventSource = BaseApplication.getRequest().getParameter("event_source");
        if (eventSource == null) {
            eventSource = "not found";
        }
        return StringInterner.intern((String)eventSource);
    }

    public static ResponseAction getRedirectResponseAction(String url) {
        log.debug((Object)("Response: redirect to " + url));
        return ResponseFactory.getInstance().getRedirectResponse(url);
    }

    public static ResponseAction getRedirectSelfResponseAction() {
        return ResponseFactory.getInstance().getRedirectSelfResponse();
    }

    public static ResponseAction getRedirectToRootResponseAction() {
        return ResponseFactory.getInstance().getRedirectResponse(UrlUtil.getRootURI());
    }

    public static ResponseAction getDefaultResponseAction() {
        return ResponseFactory.getInstance().getDefaultResponse();
    }
}

