/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.controller.requestProcessor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import webr.framework.controller.requestProcessor.RequestProcessor;

public class RequestProcessorContainer
implements Iterable<RequestProcessor> {
    private List<RequestProcessor> myRequestProcessors;

    @Override
    public Iterator<RequestProcessor> iterator() {
        return this.myRequestProcessors.iterator();
    }

    public List<RequestProcessor> getRequestProcessors() {
        return this.myRequestProcessors;
    }

    public void setRequestProcessors(List<RequestProcessor> requestProcessors) {
        if (requestProcessors != null) {
            RequestProcessorContainer.sortRequestProcessors(requestProcessors);
        }
        this.myRequestProcessors = requestProcessors;
    }

    private static void sortRequestProcessors(List<RequestProcessor> requestProcessors) {
        Rel[][] relMatrix = RequestProcessorContainer.initRelationMatrix(requestProcessors);
        RequestProcessorContainer.closeRelation(requestProcessors, relMatrix);
        RequestProcessorContainer.sort(requestProcessors, relMatrix);
        RequestProcessorContainer.checkSort(requestProcessors);
    }

    private static void checkSort(List<RequestProcessor> requestProcessors) {
        for (int i = 0; i < requestProcessors.size(); ++i) {
            RequestProcessor p1 = requestProcessors.get(i);
            Map<RequestProcessor, String> deps = p1.getDependentRequestProcessors();
            for (int j = 0; j < requestProcessors.size(); ++j) {
                RequestProcessor p2 = requestProcessors.get(j);
                String relS = deps.get(p2);
                if (relS == null) continue;
                Rel rel = Rel.valueOf(relS);
                assert (!(rel == Rel.AFTER && i <= j || rel == Rel.BEFORE && i >= j)) : "Request processors sort failed: [" + p1.getClass().getName() + ":" + p2.getClass().getName() + "]";
            }
        }
    }

    private static void sort(List<RequestProcessor> requestProcessors, Rel[][] relMatrix) {
        int size = requestProcessors.size();
        boolean[] processed = new boolean[size];
        Arrays.fill(processed, false);
        ArrayList<RequestProcessor> result = new ArrayList<RequestProcessor>();
        block0: for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (processed[j]) continue;
                boolean isMin = true;
                for (int k = 0; k < size; ++k) {
                    if (processed[k] || relMatrix[j][k] != Rel.AFTER) continue;
                    isMin = false;
                    break;
                }
                if (!isMin) continue;
                result.add(requestProcessors.get(j));
                processed[j] = true;
                continue block0;
            }
        }
        requestProcessors.clear();
        requestProcessors.addAll(result);
    }

    private static Rel[][] initRelationMatrix(List<RequestProcessor> requestProcessors) {
        Rel[][] relMatrix = new Rel[requestProcessors.size()][requestProcessors.size()];
        for (int row = 0; row < relMatrix.length; ++row) {
            RequestProcessor rowProcessor = requestProcessors.get(row);
            for (int col = 0; col < relMatrix[row].length; ++col) {
                RequestProcessor colProcessor = requestProcessors.get(col);
                if (row == col) {
                    relMatrix[row][col] = Rel.WITH;
                    continue;
                }
                if (!rowProcessor.getDependentRequestProcessors().containsKey(colProcessor)) continue;
                Rel rel = Rel.valueOf(rowProcessor.getDependentRequestProcessors().get(colProcessor));
                RequestProcessorContainer.setRelation(relMatrix, row, col, rel, rowProcessor, colProcessor);
            }
        }
        return relMatrix;
    }

    private static void closeRelation(List<RequestProcessor> requestProcessors, Rel[][] relMatrix) {
        for (int k = 0; k < relMatrix.length; ++k) {
            for (int row = 0; row < relMatrix.length; ++row) {
                for (int col = 0; col < relMatrix[row].length; ++col) {
                    Rel a = relMatrix[row][k];
                    Rel b = relMatrix[k][col];
                    Rel rel = null;
                    if (a != null && b != null) {
                        if (a == Rel.WITH || b == Rel.WITH) {
                            rel = a == Rel.WITH ? b : a;
                        } else if (a == b) {
                            rel = a;
                        }
                    }
                    if (rel == null) continue;
                    RequestProcessorContainer.setRelation(relMatrix, row, col, rel, requestProcessors.get(row), requestProcessors.get(col));
                }
            }
        }
    }

    private static void setRelation(Rel[][] relMatrix, int row, int col, Rel rel, RequestProcessor rowProcessor, RequestProcessor colProcessor) {
        if (relMatrix[row][col] != null) {
            if (relMatrix[row][col] != rel) {
                throw new IllegalStateException("Request processor [" + rowProcessor.getClass().getName() + "] " + "is \"" + (Object)((Object)relMatrix[row][col]) + "\" and \"" + (Object)((Object)rel) + "\" " + "processor [" + colProcessor.getClass().getName() + "]");
            }
        } else {
            relMatrix[row][col] = rel;
            relMatrix[col][row] = rel.myInvert;
        }
    }

    private static enum Rel {
        BEFORE(-1),
        AFTER(1),
        WITH(0);

        Rel myInvert;
        int myOrder;

        private Rel(int order) {
            this.myOrder = order;
        }

        static {
            Rel.BEFORE.myInvert = AFTER;
            Rel.AFTER.myInvert = BEFORE;
            Rel.WITH.myInvert = WITH;
        }
    }
}

