/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.function;

import java.lang.reflect.Field;
import java.util.regex.Pattern;
import jetbrains.mps.gtext.runtime.BaseHtmlStringUtil;

public final class HtmlStringUtil
extends BaseHtmlStringUtil {
    private static final String EMPTY_STRING = "";
    private static final Pattern _newLine = Pattern.compile("\n");
    private static final Pattern _doubleQuote = Pattern.compile("\"");

    private HtmlStringUtil() {
    }

    public static String singleLine(String s) {
        if (s == null) {
            return EMPTY_STRING;
        }
        return s.replace('\n', ' ');
    }

    public static String doubleToSingleQuotes(String s) {
        if (s == null) {
            return EMPTY_STRING;
        }
        return s.replace('\"', '\'');
    }

    public static String singleLineAnddoubleToSingleQuotes(String string) {
        return HtmlStringUtil.doubleToSingleQuotes(HtmlStringUtil.singleLine(string));
    }

    public static String singleLineOld(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        return _newLine.matcher(string).replaceAll(" ");
    }

    public static String doubleToSingleQuotesOld(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        return _doubleQuote.matcher(string).replaceAll("'");
    }

    public static String singleLineAnddoubleToSingleQuotesOld(String string) {
        return HtmlStringUtil.doubleToSingleQuotesOld(HtmlStringUtil.singleLineOld(string));
    }

    public static String html(Object o) {
        return BaseHtmlStringUtil.html((Object)o);
    }

    static {
        try {
            Class<BaseHtmlStringUtil> cl = BaseHtmlStringUtil.class;
            Field field = cl.getDeclaredField("_charsToEntities");
            field.setAccessible(true);
            String[] charMap = (String[])field.get(null);
            for (int i = 0; i < charMap.length; ++i) {
                if (!Character.isHighSurrogate((char)i) && !Character.isLowSurrogate((char)i)) continue;
                charMap[i] = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum EscapeKind {
        ESCAPE_HTML,
        ESCAPE_STRING_LITERAL,
        SINGLE_LINE,
        DOUBLE_TO_SINGLE_QUOTES,
        SINGLE_LINE_AND_DOUBLE_TO_SINGLE_QUOTES;

    }
}

