/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.textBuilder;

import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import webr.framework.textBuilder.WebrBuffer;

public class RecursiveBuffer
extends WebrBuffer {
    private final List<Object> buffer = new ArrayList<Object>();
    private List<RecursiveBuffer> nested;
    private int ownSize = 0;
    private RecursiveBuffer parent = null;
    private boolean locked = false;

    void flushTo(OutputStream out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flushTo(Writer writer) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(@Nullable String text) {
        if (!this.locked) {
            this.locked = true;
            try {
                this.buffer.add(text);
            }
            finally {
                this.locked = false;
            }
        } else {
            throw new IllegalStateException("Can't append locked buffer!");
        }
        this.ownSize += text == null ? 0 : text.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void append(RecursiveBuffer rb) {
        if (rb == this || this.hasAncestor(rb)) {
            throw new IllegalArgumentException("Buffer can't has itself as ancestor");
        }
        rb.parent = this;
        if (!this.locked) {
            this.locked = true;
            try {
                this.buffer.add(rb);
            }
            finally {
                this.locked = false;
            }
        } else {
            throw new IllegalStateException("Can't append locked buffer!");
        }
        this.getNested().add(rb);
    }

    private boolean hasAncestor(RecursiveBuffer rb) {
        return this.parent != null && (this.parent == rb || this.parent.hasAncestor(rb));
    }

    private List<RecursiveBuffer> getNested() {
        if (this.nested == null) {
            this.nested = new ArrayList<RecursiveBuffer>();
        }
        return this.nested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StringBuilder getText(@Nullable StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder(this.getSize());
        }
        if (!this.locked) {
            this.locked = true;
            try {
                for (Object o : this.buffer) {
                    if (o instanceof RecursiveBuffer) {
                        ((RecursiveBuffer)o).getText(sb);
                        continue;
                    }
                    sb.append(o);
                }
            }
            finally {
                this.locked = false;
            }
        } else {
            throw new IllegalStateException("Can't get text of locked buffer!");
        }
        return sb;
    }

    @Override
    public int getSize() {
        int size = this.ownSize;
        if (this.nested != null) {
            for (RecursiveBuffer rb : this.nested) {
                size += rb.getSize();
            }
        }
        return size;
    }

    @Override
    public String getString() {
        return this.getText(null).toString();
    }

    @Override
    public CharSequence getCharSequence() {
        return this.getText(null);
    }
}

