/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.textBuilder;

import java.io.IOException;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.textBuilder.ListStringBuffer;
import webr.framework.textBuilder.PipeBuffer;
import webr.framework.textBuilder.TBuilderContext;
import webr.framework.textBuilder.WebrContent;

public class StreamBuilderContext
extends TBuilderContext {
    protected static final Log log = LogFactory.getLog(StreamBuilderContext.class);

    protected StreamBuilderContext() {
    }

    public static TBuilderContext create() {
        return new TBuilderContext();
    }

    public static TBuilderContext create(boolean streamed) {
        return streamed ? new StreamBuilderContext() : new TBuilderContext();
    }

    @Override
    public void initBuffer() {
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public CharSequence getCharSequence() {
        return null;
    }

    @Override
    public void start(ServletResponse response) {
        super.start(response);
        this.start();
    }

    void start() {
        this.buffer = new PipeBuffer(this.out);
        WebrContent rootContent = new WebrContent(ROOT, this.buffer);
        this.getWebrContents().put(ROOT, rootContent);
        this.getWebrContentsStack().push(this.getWebrContents().get(ROOT));
    }

    @Override
    public void startContentBlock(String name) {
        WebrContent c = this.getWebrContents().get(name);
        if (c == null) {
            c = new WebrContent(name, new ListStringBuffer());
            this.getWebrContents().put(name, c);
        } else if (c.isFlushed()) {
            throw new IllegalStateException("Attempt to add content to flushed placeholder [" + name + "]");
        }
        this.getWebrContentsStack().push(c);
        this.buffer = c.getBuffer();
    }

    @Override
    public void endContentBlock() {
        this.getWebrContentsStack().pop();
        this.buffer = this.getWebrContentsStack().peek().getBuffer();
    }

    @Override
    public void addContentPlaceholder(String name) {
        WebrContent c = this.getWebrContents().get(name);
        if (c == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No content for placeholder [" + name + "]"));
            }
            c = new WebrContent(name, null);
            c.setFlushed(true);
            this.getWebrContents().put(name, c);
        } else {
            c.flushTo(this.out);
        }
    }

    @Override
    public void flush() {
        try {
            this.flushInternal();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void end() {
        this.out.close();
        if (log.isDebugEnabled()) {
            for (WebrContent c : this.contents.values()) {
                if (c.isFlushed()) continue;
                log.debug((Object)("Unflushed content [" + c.getName() + "]"));
            }
        }
    }
}

