/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.url;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostToBaseUrlConfiguration {
    private static final Log log = LogFactory.getLog(HostToBaseUrlConfiguration.class);
    private Map<String, String> myHostToBaseUrlMapping;
    private String myDefaultBaseUrl;
    private transient String myBaseUrl;

    public void setHostToBaseUrlMapping(Map<String, String> hostToBaseUrlMapping) {
        this.myHostToBaseUrlMapping = hostToBaseUrlMapping;
    }

    public void setDefaultBaseUrl(String defaultBaseUrl) {
        this.reset();
        this.myDefaultBaseUrl = defaultBaseUrl;
    }

    public void reset() {
        this.myBaseUrl = null;
    }

    public String getBaseUrl() {
        if (this.myBaseUrl == null) {
            this.myBaseUrl = this.myDefaultBaseUrl;
            try {
                InetAddress actualAddress = InetAddress.getLocalHost();
                String actualCanonicalHostName = actualAddress.getCanonicalHostName();
                log.info((Object)("actualCanonicalHostName: " + actualCanonicalHostName));
                for (String host : this.myHostToBaseUrlMapping.keySet()) {
                    try {
                        InetAddress hostAddress = InetAddress.getByName(host);
                        if (!actualCanonicalHostName.equals(hostAddress.getCanonicalHostName())) continue;
                        this.myBaseUrl = this.myHostToBaseUrlMapping.get(host);
                    }
                    catch (UnknownHostException e) {
                        log.error((Object)("Unknown host " + host));
                    }
                }
            }
            catch (UnknownHostException e) {
                String osName = System.getProperty("os.name");
                boolean isWindows = osName != null ? osName.toLowerCase().startsWith("windows") : false;
                log.warn((Object)String.format("Local host name is not resolvable. Most often it might be fixed by adding the lines %n127.0.0.1 localhost %n127.0.0.1 [YOUR_HOSTNAME] %nto the [%s] file", isWindows ? "%SystemRoot%\\system32\\drivers\\etc\\hosts" : "/etc/hosts"), (Throwable)e);
            }
        }
        return this.myBaseUrl;
    }
}

