Webr.Event = function () {
};
Webr.Event.loadingListener = new Webr.event.LoadingServerEventListener();
Webr.Event.DEFAULT_REQUEST_TIMEOUT = 6 * 60 * 1000;
Webr.Event.send = function (config) {
  if (!Webr.event.ResponseServerEventListener.SYNC_CALL_IN_PROGRESS) {
    if (Webr.event.InProgressEventListener.get().checkDoubleSubmit(config)) {
      config = Webr.event.ServerEventConfig.createCopy(config);
      config.timeout = config.timeout || Webr.Event.DEFAULT_REQUEST_TIMEOUT;
      config.listeners = config.listeners || [];
      config.listeners.push(new Webr.event.ResponseServerEventListener(config.sync));
      config.sync = false;
      if (!config.hideLoadingPopup) {
        config.listeners.push(Webr.Event.loadingListener);
      }

      config.handlerUrl = config.handlerUrl || Webr.Event.handlerUrl;
      config.method = config.method || "POST";
      if ((!config.fileInput || config.fileInput.length <= 0) && config.collectFormElements && config.collectFileElements) {
        var fileInputs = Webr.event.UploadEvent.findNonemptyFileInputs(config.rootElement);
        if (fileInputs.length > 0) {
          config.fileInput = fileInputs;
        }

      }

      var serverEvent;
      if (config.fileInput && config.fileInput.length > 0) {
        serverEvent = new Webr.event.UploadEvent(config);
      } else {
        serverEvent = new Webr.event.ServerEvent(config);
      }

      Webr.event.InProgressEventListener.get().rememberEvent(serverEvent);
      serverEvent.send();
    }

  }

};
Webr.Event.post = function (config) {
  config.method = "POST";
  config.headers = config.headers || {};
  config.headers["Content-Type"] = "application/x-www-form-urlencoded";
  Webr.Event.send(config);
};
Webr.Event.get = function (config) {
  config.method = "GET";
  Webr.Event.send(config);
};
Webr.Event.put = function (config) {
  config.method = "PUT";
  Webr.Event.send(config);
};
Webr.Event.sendDelete = function (config) {
  config.method = "DELETE";
  Webr.Event.send(config);
};
Webr.Event.callMethod = function (methodName, params, baseConfig) {
  var config = Webr.event.ServerEventConfig.createCopy(baseConfig, {sync: false, preventDoubleSubmit: false, processRecentOnly: false, collectFormElements: true, eventName: methodName, eventParameters: params});
  Webr.Event.post(config);
};
Webr.Event.redirect = function (url) {
  Webr.event.ResponseServerEventListener.PAGE_CHANGED = true;
  if (Webr.event.UploadEvent.IS_IE) {
    var anchor = document.createElement("a");
    anchor.href = url;
    document.body.appendChild(anchor);
    anchor.click();
  } else {
    window.location = url;
  }

};
Webr.Event.reload = function () {
  Webr.event.ResponseServerEventListener.PAGE_CHANGED = true;
  window.location.reload();
};
Webr.Event.reloadInternal = function (success, error) {
  jQuery.ajax({url: Webr.Event.internalReloadUrl || window.location.href, timeout: Webr.Event.DEFAULT_REQUEST_TIMEOUT}).done(success).fail(error);
};
Webr.Event.registerFileInput = function (fileInputId, config) {
  var fileInput = document.getElementById(fileInputId);
  config.fileInput = [fileInput];
  fileInput.onchange = function () {
    Webr.Event.post(config);
  };
};
Webr.Event.getUrlParam = function (name) {
  var params = window["$getUrlParam$"];
  if (!params) {
    params = {};
    window.location.href.replace(new RegExp("[?&]+([^=&]+)=([^&]*)", "gi"), function (m, key, value) {
      params[key] = value;
    });
    window["$getUrlParam$"] = params;
  }

  return params[name];
};
