Webr.HashSet = function () {
  this._size = 0;
  this.numberField = "_KEY_IN_SET_" + Webr.HashSet.instanceCount;
  Webr.HashSet.instanceCount += 1;
};
Webr.HashSet.prototype.add = function (item) {
  if (item == null) {
    throw "Can't add undefined item.";
  }

  if (!this.items) {
    this.items = {};
    this._key = 0;
  }

  if (this.contains(item)) {
    //Already in set!
    return ;
  }

  this.items[this._key] = item;
  item[this.numberField] = this._key;
  this._key += 1;
  this._size += 1;
};
Webr.HashSet.prototype.remove = function (item) {
  if (item[this.numberField] == null) {
    throw "Item [" + item + "] not from this set.";
  }

  delete this.items[item[this.numberField]];
  delete item[this.numberField];
  this._size -= 1;
};
Webr.HashSet.prototype.contains = function (item) {
  return item[this.numberField];
};
Webr.HashSet.prototype.size = function () {
  return this._size;
};
Webr.HashSet.prototype.forEach = function (f) {
  for ( var key in this.items) {
    if (!f(this.items[key])) {
      return false;
    }

  }

  return true;
};
Webr.HashSet.prototype.toString = function (renderer) {
  var first = true;
  var string = "";
  this.forEach(function (value) {
    if (!first) {
      string += ",";
    }

    string += renderer(value);
    first = false;
  });
  return string;
};
Webr.HashSet.instanceCount = 0;
Webr.NumberSet = function (throwsEx) {
  Webr.NumberSet.superclass.constructor.call(this);
  this.throwExIfNotContains = true;
  if (throwsEx === false) {
    this.throwExIfNotContains = false;
  }

};
{
  var F = new Function();
  F.prototype = Webr.HashSet.prototype;
  Webr.NumberSet.prototype = new F();
  Webr.NumberSet.prototype.constructor = Webr.NumberSet;
  Webr.NumberSet.superclass = Webr.HashSet.prototype;
}

Webr.NumberSet.prototype.add = function (item) {
  if (item == null) {
    throw "Can't add undefined item.";
  }

  if (!this.items) {
    this.items = {};
  }

  if (this.contains(item)) {
    //Already in set!
    return ;
  }

  this.items[item] = true;
  this._size += 1;
};
Webr.NumberSet.prototype.remove = function (item) {
  if (this.items == null || (this.items[item] == null)) {
    if (this.throwExIfNotContains) {
      Webr.component.Debug.dumpStackTrace();
      throw "Item [" + item + "] not from this set.";
    } else {
      return ;
    }

  }

  delete this.items[item];
  this._size -= 1;
};
Webr.NumberSet.prototype.contains = function (item) {
  return this.items[item];
};
Webr.NumberSet.prototype.forEach = function (f) {
  for ( var key in this.items) {
    if (!f(key)) {
      return false;
    }

  }

  return true;
};
