Webr.TimerUtil = function () {
  this.timeouts = new Webr.NumberSet(false);
  this.intervals = new Webr.NumberSet(false);
  this.wrapDefaultTimers();
};
Webr.TimerUtil.prototype.add = function (id, timeout) {
  var res = timeout ?this.timeouts :this.intervals;
  res.add(id);
};
Webr.TimerUtil.prototype.remove = function (id, timeout) {
  var res = timeout ?this.timeouts :this.intervals;
  //timeout could happen while we are calling function
  res.remove(id);
};
Webr.TimerUtil.prototype.contains = function (id, timeout) {
  var res = timeout ?this.timeouts :this.intervals;
  return res.contains(id);
};
Webr.TimerUtil.prototype.stopAll = function () {
  var it = this;
  this.timeouts.forEach(function (id) {
    window.clearTimeout(id);
    return true;
  });
  this.intervals.forEach(function (id) {
    window.clearInterval(id);
    return true;
  });
};
Webr.TimerUtil.prototype.wrapDefaultTimers = function () {
  var it = this;
  var timeout = window.setTimeout;
  window.setTimeout = function (f, millis) {
    var id = timeout(function () {
      it.remove(id, true);
      f();
    }, millis);
    it.add(id, true);
    return id;
  };
  var clearTimeout = window.clearTimeout;
  window.clearTimeout = function (id) {
    //Check that it's not already removed!
    it.remove(id, true);
    clearTimeout(id);
  };
  var interval = window.setInterval;
  window.setInterval = function (f, millis) {
    var id = interval(f, millis);
    it.add(id, false);
    return id;
  };
  var clearInterval = window.clearInterval;
  window.clearInterval = function (id) {
    it.remove(id, false);
    clearInterval(id);
  };
    

  //Fix indexOf for IE7
  if (!(Array.prototype.indexOf) && false) {
    Array.prototype.indexOf = function (o) {
      //May be we can make it even faster: sort + binary search
      for (var i = 0; i < this.length; ++i) {
        if (this[i] === o) {
          return i;
        }

      }

      return -1;
    };
  }

};
Webr.TimerUtil.FINGERPRINT = "WEBR_TIMER";
Webr.TimerUtil.clearAll = function () {
  Webr.TimerUtil.WEBR_TIMER.stopAll();
};
Webr.TimerUtil.WEBR_TIMER = new Webr.TimerUtil();
