/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.stateless.template.dependency;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.javascript.runtime.jsDependencies.UrlGetter;
import jetbrains.mps.webr.runtime.resource.ResourceBundle;
import jetbrains.mps.webr.runtime.resource.ResourceBundleManager;
import jetbrains.mps.webr.runtime.templateComponent.LinkUtil;
import jetbrains.mps.webr.stateless.template.dependency.DependencyCollection;
import jetbrains.mps.webr.stateless.template.dependency.TemplateDependency;
import jetbrains.mps.webr.stateless.template.dependency.TemplateDependencyContainer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import webr.framework.controller.BaseApplication;
import webr.framework.url.UrlUtil;

public abstract class DependencyCache {
    private ConcurrentMap<String, Tuples._2<ResourceBundle, Iterable<String>>> bundles = new ConcurrentHashMap<String, Tuples._2<ResourceBundle, Iterable<String>>>();
    private TemplateDependencyContainer myDependencyContainer;
    private String myMimeType;
    private String myBundleNamePrefix;
    private String myBundleNameExt;

    public Iterable<String> getDependencyUrls(@NotNull String templateClassName, boolean bundled, @NotNull DependencyCollection dependencyCollection) {
        String bundleUrl;
        ISequence urls = bundled ? ((bundleUrl = this.getBundleUrl(templateClassName, dependencyCollection)) != null ? Sequence.singleton((Object)bundleUrl) : Sequence.fromIterable(Collections.emptyList())) : this.getAllUrls(templateClassName, dependencyCollection);
        return urls;
    }

    private Iterable<String> getAllUrls(@NotNull String templateClassName, @NotNull DependencyCollection dependencyCollection) {
        Iterable<String> dependencyNames = this.collectDependencyNames(templateClassName, dependencyCollection);
        dependencyCollection.addNewDependencies(dependencyNames);
        ISequence dependencies = Sequence.fromIterable(this.selectUrlGetters(dependencyNames)).select((_FunctionTypes._return_P1_E0)new ISelector<UrlGetter, String>(){

            public String select(UrlGetter it) {
                return it.getUrl();
            }
        });
        return dependencies;
    }

    private String getBundleUrl(@NotNull String templateClassName, @Nullable DependencyCollection dependencyCollection) {
        ResourceBundle bundle = this.getDependencyResourceBundle(templateClassName, dependencyCollection);
        if (bundle == null) {
            return null;
        }
        String bundleFileName = bundle.getPath();
        UrlUtil.Url u = new UrlUtil.Url();
        u.setIsLocal();
        u.addPathElements(new String[]{"_resourceBundle", bundleFileName});
        return u.toString();
    }

    public void clear() {
        this.bundles = new ConcurrentHashMap<String, Tuples._2<ResourceBundle, Iterable<String>>>();
    }

    @Nullable
    protected ResourceBundle getDependencyResourceBundle(@NotNull String templateClassName, @NotNull DependencyCollection dependencyCollection) {
        ConcurrentMap<String, Tuples._2<ResourceBundle, Iterable<String>>> _bundles = this.bundles;
        boolean cacheBundles = dependencyCollection.getLoadedDependencies().isEmpty();
        Tuples._2 bundlePair = null;
        Locale locale = DependencyCache.check_6a64bv_a0h0e((Localizer)ServiceLocator.getOptionalBean((String)"localizer"));
        if (cacheBundles) {
            bundlePair = (Tuples._2)_bundles.get(locale + "_" + templateClassName);
        }
        if (bundlePair == null) {
            Iterable<String> dependencyNames = this.collectDependencyNames(templateClassName, dependencyCollection);
            if (Sequence.fromIterable(dependencyNames).isEmpty()) {
                return null;
            }
            Iterable<UrlGetter> urlGetters = this.selectUrlGetters(dependencyNames);
            bundlePair = MultiTuple.from((Object)new ResourceBundle(this.getMimeType(), locale, this.getBundleNamePrefix(), this.getBundleNameExt(), urlGetters), dependencyNames);
            Tuples._2<ResourceBundle, Iterable<String>> oldPair = null;
            if (cacheBundles) {
                oldPair = _bundles.putIfAbsent(locale + "_" + templateClassName, (Tuples._2<ResourceBundle, Iterable<String>>)bundlePair);
            }
            if (oldPair == null) {
                ResourceBundleManager.getInstance().putResourceBundle((ResourceBundle)bundlePair._0());
            }
        }
        dependencyCollection.addNewDependencies((Iterable)bundlePair._1());
        return (ResourceBundle)bundlePair._0();
    }

    protected abstract Iterable<String> getImmediateDependecies(TemplateDependency var1);

    protected abstract Iterable<String> sortDependencies(Iterable<String> var1, Set<String> var2);

    protected abstract Iterable<UrlGetter> selectUrlGetters(Iterable<String> var1);

    private Set<String> templatesDFS(String templateName) {
        ISetSequence dependencies = SetSequence.fromSet(new LinkedHashSet());
        ISetSequence reviewedTemplates = SetSequence.fromSet(new HashSet());
        this.templatesDFS(templateName, (Set<String>)dependencies, (Set<String>)reviewedTemplates);
        return dependencies;
    }

    private void templatesDFS(String currentTemplateName, Set<String> dependencies, Set<String> reviewedTemplates) {
        if (SetSequence.fromSet(reviewedTemplates).contains((Object)currentTemplateName)) {
            return;
        }
        SetSequence.fromSet(reviewedTemplates).addElement((Object)currentTemplateName);
        TemplateDependency currentTemplate = this.getDependencyContainer().getTemplateDependency(currentTemplateName);
        if (DependencyCache.isNotEmpty_6a64bv_a0e0j(currentTemplate.getSuperTemplate())) {
            this.templatesDFS(currentTemplate.getSuperTemplate(), dependencies, reviewedTemplates);
        }
        SetSequence.fromSet(dependencies).addSequence(Sequence.fromIterable(this.getImmediateDependecies(currentTemplate)));
        for (String includedTemplate : ListSequence.fromList(currentTemplate.getIncludedTemplates())) {
            this.templatesDFS(includedTemplate, dependencies, reviewedTemplates);
        }
    }

    public Iterable<String> collectDependencyNames(String templateName, DependencyCollection dependencyCollection) {
        Iterable<String> dependencyNames = this.templatesDFS(templateName);
        dependencyNames = this.sortDependencies(dependencyNames, dependencyCollection.getLoadedDependencies());
        return dependencyNames;
    }

    public TemplateDependencyContainer getDependencyContainer() {
        return this.myDependencyContainer;
    }

    public void setDependencyContainer(TemplateDependencyContainer value) {
        this.myDependencyContainer = value;
    }

    public String getMimeType() {
        return this.myMimeType;
    }

    public void setMimeType(String value) {
        this.myMimeType = value;
    }

    public String getBundleNamePrefix() {
        return this.myBundleNamePrefix;
    }

    public void setBundleNamePrefix(String value) {
        this.myBundleNamePrefix = value;
    }

    public String getBundleNameExt() {
        return this.myBundleNameExt;
    }

    public void setBundleNameExt(String value) {
        this.myBundleNameExt = value;
    }

    public static boolean useResourceBundle() {
        String debugParam = BaseApplication.getRequest().getParameter("debugUseResourceBundles");
        if (debugParam == null || debugParam.length() == 0) {
            return LinkUtil.useResourceBundle();
        }
        return Boolean.valueOf(debugParam);
    }

    private static Locale check_6a64bv_a0h0e(Localizer checkedDotOperand) {
        if (null != checkedDotOperand) {
            return checkedDotOperand.getLocale();
        }
        return null;
    }

    public static boolean isNotEmpty_6a64bv_a0e0j(String str) {
        return str != null && str.length() > 0;
    }
}

