/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.stateless.template.runtime;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.webr.stateless.template.dependency.CssDependencyCache;
import jetbrains.mps.webr.stateless.template.dependency.DependencyCache;
import jetbrains.mps.webr.stateless.template.dependency.DependencyCollection;
import jetbrains.mps.webr.stateless.template.dependency.JsDependencyCache;
import jetbrains.mps.webr.stateless.template.runtime.IRenderable;
import jetbrains.mps.webr.stateless.template.runtime.TemplateBuilderContext;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseTemplate
implements IRenderable {
    private List<String> excludeDependeincesOfTemplates;

    protected BaseTemplate() {
    }

    protected void init(Builder builder) {
    }

    public BaseTemplate exludeDependencies(@NotNull Class<? extends BaseTemplate> templateClass) {
        return this.exludeDependencies(templateClass.getName());
    }

    public BaseTemplate exludeDependencies(String templateClassName) {
        if (this.excludeDependeincesOfTemplates == null) {
            this.excludeDependeincesOfTemplates = ListSequence.fromList(new ArrayList());
        }
        ListSequence.fromList(this.excludeDependeincesOfTemplates).addElement((Object)templateClassName);
        return this;
    }

    private TemplateBuilderContext addExcludeDependencies(@NotNull TemplateBuilderContext context) {
        if (this.excludeDependeincesOfTemplates != null) {
            for (String templateClassName : ListSequence.fromList(this.excludeDependeincesOfTemplates)) {
                this.addExludeDependencies(templateClassName, (JsDependencyCache)ServiceLocator.getBean((String)"statelessJsDependencies"), context.getJsDependencyCollection());
                this.addExludeDependencies(templateClassName, (CssDependencyCache)ServiceLocator.getBean((String)"statelessCssDependencies"), context.getCssDependencyCollection());
            }
        }
        return context;
    }

    private void addExludeDependencies(@NotNull String templateClassName, @NotNull DependencyCache dependencyCache, @NotNull DependencyCollection dependencyCollection) {
        dependencyCollection.addNewDependencies(dependencyCache.collectDependencyNames(templateClassName, dependencyCollection));
    }

    public StreamingOutput renderToStreamingOutput() {
        return new StreamingOutput(){

            public void write(@NotNull OutputStream out) throws IOException, WebApplicationException {
                BaseTemplate.this.render(out);
            }
        };
    }

    public Response render() {
        Response.ResponseBuilder builder = Response.ok();
        this.render(builder);
        return builder.build();
    }

    public Response.ResponseBuilder render(Response.ResponseBuilder builder) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoStore(true);
        cacheControl.setNoCache(true);
        cacheControl.setMustRevalidate(true);
        MediaType utf8Html = MediaType.valueOf((String)"text/html;charset=UTF-8");
        return this.render(builder, utf8Html, cacheControl);
    }

    public Response.ResponseBuilder render(Response.ResponseBuilder builder, MediaType mediaType, CacheControl cacheControl) {
        if (cacheControl != null) {
            builder.cacheControl(cacheControl);
        }
        builder.type(mediaType);
        return builder.entity((Object)this.renderToStreamingOutput());
    }

    public String renderToString() {
        StringWriter writer = new StringWriter();
        this.render(writer);
        return writer.toString();
    }

    public void render(@NotNull OutputStream out) throws IOException {
        TemplateBuilderContext builderContext = this.addExcludeDependencies(new TemplateBuilderContext(out));
        this.render(builderContext);
        builderContext.close();
    }

    public void render(@NotNull Writer writer) {
        TemplateBuilderContext builderContext = this.addExcludeDependencies(new TemplateBuilderContext(writer));
        this.render(builderContext);
        try {
            builderContext.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void render(@NotNull TemplateBuilderContext builderContext) {
        this.render(builderContext, null);
    }

    @Override
    public void render(@NotNull TemplateBuilderContext builderContext, @Nullable IRenderable callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Call to BaseTemplate render with empty callback.");
        }
        callback.render(builderContext, null);
    }

    protected static void include(@Nullable IRenderable renderable, @NotNull TemplateBuilderContext context) {
        if (renderable != null) {
            renderable.render(context, null);
        }
    }

    public static abstract class Builder {
        public BaseTemplate template;

        protected Builder(BaseTemplate template) {
            this.template = template;
        }
    }
}

