/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.userManagement.runtime;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.webr.runtime.util.DomainUtil;
import jetbrains.mps.webr.userManagement.runtime.ClientPrincipalManager;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import webr.framework.controller.BaseApplication;

public class PrincipalManagerImpl
implements PrincipalManager {
    private String principalName = PrincipalManagerImpl.class.getName() + ".__PRINCIPAL__";
    private String loggedInName = PrincipalManagerImpl.class.getName() + ".__LOGGED_IN__";
    private ClientPrincipalManager clientPrincipalManager;
    private final ThreadLocal<LinkedList<Object>> temporaryServerPrincipal = new ThreadLocal();
    private final Map<Serializable, Integer> principals = MapSequence.fromMap(new HashMap());

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public void setLoggedInName(String loggedInName) {
        this.loggedInName = loggedInName;
    }

    public void setClientPrincipalManager(ClientPrincipalManager clientPrincipalManager) {
        this.clientPrincipalManager = clientPrincipalManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLoggedInCount() {
        Map<Serializable, Integer> map = this.principals;
        synchronized (map) {
            return MapSequence.fromMap(this.principals).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServerPrincipal(Object principal) {
        Object logedInPrincipal = this.getPrincipal();
        if (logedInPrincipal != null) {
            if (logedInPrincipal.equals(principal)) {
                return;
            }
            this.unsetServerPrincipal();
        }
        BaseApplication.setSessionField((String)this.principalName, (Object)principal);
        BaseApplication.setSessionField((String)this.loggedInName, (Object)Boolean.TRUE);
        Map<Serializable, Integer> map = this.principals;
        synchronized (map) {
            Serializable _principal = this.getPrincipalRaw();
            if (MapSequence.fromMap(this.principals).containsKey((Object)_principal)) {
                int online = (Integer)MapSequence.fromMap(this.principals).get((Object)_principal) + 1;
                MapSequence.fromMap(this.principals).put((Object)_principal, (Object)online);
            } else {
                MapSequence.fromMap(this.principals).put((Object)_principal, (Object)1);
            }
        }
    }

    @Override
    public void unsetServerPrincipal() {
        this.removePrincipal(this.getPrincipalRaw());
        BaseApplication.setSessionField((String)this.principalName, null);
        BaseApplication.setSessionField((String)this.loggedInName, null);
    }

    @Override
    public void unsetServerPrincipal(HttpSession session) {
        this.removePrincipal(this.getPrincipalRaw(session));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePrincipal(Serializable principal) {
        if (principal == null) {
            return;
        }
        Map<Serializable, Integer> map = this.principals;
        synchronized (map) {
            if (MapSequence.fromMap(this.principals).containsKey((Object)principal)) {
                int online = (Integer)MapSequence.fromMap(this.principals).get((Object)principal) - 1;
                if (online == 0) {
                    MapSequence.fromMap(this.principals).removeKey((Object)principal);
                } else {
                    MapSequence.fromMap(this.principals).put((Object)principal, (Object)online);
                }
            }
        }
    }

    @Override
    public boolean isLoggedIn() {
        return Boolean.TRUE.equals(BaseApplication.getSessionField((String)this.loggedInName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLoggedIn(Serializable principalRaw) {
        Map<Serializable, Integer> map = this.principals;
        synchronized (map) {
            return SetSequence.fromSet((Set)MapSequence.fromMap(this.principals).keySet()).contains((Object)principalRaw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Serializable> getLoggedInPrincipals() {
        Map<Serializable, Integer> map = this.principals;
        synchronized (map) {
            return SetSequence.fromSetWithValues(new HashSet(), (Iterable)MapSequence.fromMap(this.principals).keySet());
        }
    }

    @Override
    public Object getPrincipal() {
        List tmp = this.temporaryServerPrincipal.get();
        if (ListSequence.fromList((List)tmp).isNotEmpty()) {
            return ListSequence.fromList((List)tmp).first();
        }
        return BaseApplication.getSessionField((String)this.principalName);
    }

    private Serializable getPrincipalRaw() {
        return this.getPrincipalRaw(BaseApplication.getRequest().getSession());
    }

    @Override
    public Serializable getPrincipalRaw(HttpSession session) {
        Map map = null;
        try {
            map = BaseApplication.getSessionBean((HttpSession)session);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return map == null ? null : (Serializable)map.get(this.principalName);
    }

    @Override
    public void setClientPrincipal(Object userPrincipal) {
        String cookieValue = this.getClientPrincipalValue(userPrincipal);
        String localDomain = BaseApplication.getRequest().getServerName();
        String domainPattern = DomainUtil.getDomainPattern((String)localDomain);
        BaseApplication.setCookieField((String)this.principalName, (Object)cookieValue, (String)domainPattern);
    }

    @Override
    public Object getClientPrincipal() {
        String cookieValue = (String)BaseApplication.getCookieField((String)this.principalName, (String)String.class.getName());
        return this.clientPrincipalManager.fromCookieString(cookieValue);
    }

    @Override
    public String getClientPrincipalValue() {
        return this.getClientPrincipalValue(this.getPrincipal());
    }

    @Override
    public String getClientPrincipalName() {
        return this.principalName;
    }

    private String getClientPrincipalValue(Object userPrincipal) {
        return this.clientPrincipalManager.toCookieString(userPrincipal);
    }

    @Override
    public void setTemporaryServerPrincipal(Object userPrincipal) {
        LinkedList<Object> list = this.temporaryServerPrincipal.get();
        if (list == null) {
            list = new LinkedList();
            this.temporaryServerPrincipal.set(list);
        }
        list.addFirst(userPrincipal);
    }

    @Override
    public Object unsetTemporaryServerPrincipal() {
        LinkedList<Object> list = this.temporaryServerPrincipal.get();
        if (list == null) {
            return null;
        }
        list.removeFirst();
        Object prev = list.peek();
        if (prev != null) {
            return prev;
        }
        return BaseApplication.getSessionField((String)this.principalName);
    }
}

