/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.userManagement.runtime;

import com.jetbrains.teamsys.dnq.database.TransientStoreUtil;
import java.util.Map;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.requestProcessor.WindowManager;
import jetbrains.mps.webr.runtime.templateComponent.ActionController;
import jetbrains.mps.webr.runtime.templateComponent.ActionFactory;
import jetbrains.mps.webr.runtime.templateComponent.ActionFactoryContainer;
import jetbrains.mps.webr.runtime.templateComponent.RootTemplateController;
import jetbrains.mps.webr.runtime.templateComponent.RootTemplateControllerContainer;
import jetbrains.mps.webr.runtime.templateComponent.TemplateActionController;
import jetbrains.mps.webr.runtime.url.RequestUri;
import jetbrains.mps.webr.userManagement.runtime.DecodeUtil;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.mps.webr.userManagement.runtime.SecurityNavigator;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.BaseApplication;
import webr.framework.controller.CentralManager;
import webr.framework.controller.ControllerOperations;
import webr.framework.controller.requestProcessor.RequestProcessor;
import webr.framework.runtime.response.ResponseAction;

public abstract class SecurityRequestProcessor
implements RequestProcessor {
    private static String AUTHORIZATION = "Authorization";
    private static String BASIC = "Basic ";
    protected static Log log = LogFactory.getLog(SecurityRequestProcessor.class);
    private Map<RequestProcessor, String> dependentRequestProcessors;

    public boolean isApplicable(RequestUri requestUri) {
        String controller = requestUri.getElement(0);
        boolean result = false;
        result = result || ((ActionFactoryContainer)ServiceLocator.getBean((String)"actionFactoryContainer")).containsFactory(controller);
        result = result || "_events".equalsIgnoreCase(controller);
        result = result || "rest".equalsIgnoreCase(controller);
        result = result || "_rss".equalsIgnoreCase(controller);
        result = result || "_persistent".equalsIgnoreCase(controller);
        result = result || ((RootTemplateControllerContainer)ServiceLocator.getBean((String)"rootTemplateControllerContainer")).containsTemplate(controller);
        return result;
    }

    public Map<RequestProcessor, String> getDependentRequestProcessors() {
        return this.dependentRequestProcessors;
    }

    public void setDependentRequestProcessors(Map<RequestProcessor, String> precedingRequestProcessors) {
        this.dependentRequestProcessors = precedingRequestProcessors;
    }

    public ResponseAction processRequest(RequestUri requestUri) {
        if (BaseApplication.getRequest().getHeader(AUTHORIZATION) != null) {
            this.tryBasicAuthentication(BaseApplication.getRequest().getHeader(AUTHORIZATION));
        }
        if (this.requestToLogin(requestUri)) {
            return null;
        }
        boolean principalNotFound = !((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).isLoggedIn() && !this.loginUsingClientInfo() && !this.loginAsGuest();
        String controllerName = requestUri.getElement(0);
        Object responseAction = "_persistent".equalsIgnoreCase(controllerName) ? (!this.allowPersistentFileAccess(requestUri) ? ResponseFactory.getInstance().getForbiddenResponse("You have no access to requested file.") : null) : ("rest".equalsIgnoreCase(controllerName) ? (this.isRestAllowed(requestUri) ? null : ResponseFactory.getInstance().getNotImplementedServerErrorResponse("REST API is disabled. Contact " + ((CentralManager)ServiceLocator.getBean((String)"centralManager")).getApplicationName() + " administrator")) : ("_rss".equalsIgnoreCase(controllerName) ? null : (principalNotFound ? ((SecurityNavigator)ServiceLocator.getBean((String)"securityNavigator")).getRedirectToLoginAction() : this.getCustomResponse(requestUri))));
        return responseAction;
    }

    public ResponseAction getCustomResponse(RequestUri requestUri) {
        return null;
    }

    public boolean allowPersistentFileAccess(RequestUri requestUri) {
        return true;
    }

    public boolean isRestAllowed(RequestUri requestUri) {
        return true;
    }

    private boolean requestToLogin(RequestUri requestUri) {
        boolean allowWithoutLogin;
        String name = requestUri.getElement(0);
        if ("_events".equalsIgnoreCase(name)) {
            allowWithoutLogin = false;
            WindowManager windowManager = WindowManager.getWindowManager();
            String windowId = windowManager.getRequestWindowId();
            if (windowId != null) {
                ActionController actionController = windowManager.getActionController(windowId);
                if (actionController instanceof TemplateActionController) {
                    allowWithoutLogin = ((TemplateActionController)actionController).allowAnonymous();
                } else if ("_heart_beat".equals(ControllerOperations.getEventName())) {
                    allowWithoutLogin = true;
                }
            }
        } else {
            RootTemplateController templateController = ((RootTemplateControllerContainer)ServiceLocator.getBean((String)"rootTemplateControllerContainer")).getRootTemplateController(name);
            if (templateController == null) {
                ActionFactory action = ((ActionFactoryContainer)ServiceLocator.getBean((String)"actionFactoryContainer")).getFactory(name);
                if (action != null) {
                    if (!((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).isLoggedIn()) {
                        this.loginUsingClientInfo();
                    }
                    return true;
                }
                return false;
            }
            allowWithoutLogin = templateController.getAllowAnonymous();
        }
        return allowWithoutLogin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryBasicAuthentication(String headerValue) {
        String authString;
        String encoded;
        int semicolonIndex;
        if (headerValue.startsWith(BASIC) && (semicolonIndex = (encoded = DecodeUtil.decode(authString = headerValue.substring(BASIC.length()))).indexOf(":")) >= 0) {
            String username = encoded.substring(0, semicolonIndex);
            String password = encoded.substring(semicolonIndex + 1);
            boolean $nt$_om0ly9_c0d0a0i = DnqUtils.getCurrentTransientSession() == null;
            TransientStoreSession ts1_om0ly9_c0d0a0i = DnqUtils.beginTransientSession();
            boolean wasEx_om0ly9_c0d0a0i = true;
            try {
                Object principal = this.doBasicAuthentication(username, password);
                DnqUtils.getCurrentTransientSession().flush();
                if (principal != null) {
                    ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setServerPrincipal(principal);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Logged in using basic authentification");
                    }
                    boolean bl = ((SecurityNavigator)ServiceLocator.getBean((String)"securityNavigator")).doOnLoginAction();
                    return bl;
                }
                wasEx_om0ly9_c0d0a0i = false;
            }
            finally {
                if ($nt$_om0ly9_c0d0a0i && ts1_om0ly9_c0d0a0i.isOpened()) {
                    if (wasEx_om0ly9_c0d0a0i) {
                        ts1_om0ly9_c0d0a0i.abort();
                    } else {
                        ts1_om0ly9_c0d0a0i.commit();
                    }
                }
            }
        }
        return false;
    }

    public Object getGuestPrincipal() {
        return _Txn.eval((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<Object>(){

            public Object invoke() {
                Object guest = SecurityRequestProcessor.this.doGetGuestPrincipal();
                DnqUtils.getCurrentTransientSession().flush();
                return guest;
            }
        });
    }

    protected abstract Object doGetGuestPrincipal();

    protected Object doBasicAuthentication(String username, String password) {
        return null;
    }

    private boolean loginUsingClientInfo() {
        final Wrappers._T clientUserPrincipal = new Wrappers._T(null);
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                block2: {
                    try {
                        clientUserPrincipal.value = ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).getClientPrincipal();
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break block2;
                        log.error((Object)"Can't restore user principal from client", (Throwable)e);
                    }
                }
                TransientStoreUtil.abort((TransientStoreSession)DnqUtils.getCurrentTransientSession());
            }
        });
        if (clientUserPrincipal.value != null) {
            ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setServerPrincipal(clientUserPrincipal.value);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Logged in using remembered principal");
            }
            return ((SecurityNavigator)ServiceLocator.getBean((String)"securityNavigator")).doOnLoginAction();
        }
        return false;
    }

    private boolean loginAsGuest() {
        Object guestPrincipal = this.getGuestPrincipal();
        if (guestPrincipal == null) {
            return false;
        }
        ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setServerPrincipal(guestPrincipal);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Logged in as guest");
        }
        return ((SecurityNavigator)ServiceLocator.getBean((String)"securityNavigator")).doOnLoginAction();
    }
}

