/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.wiki.processor.runtime.utils;

import jetbrains.mps.gtext.runtime.TBaseBuilderContext;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.webr.wiki.processor.runtime.BaseProcessor;
import jetbrains.mps.webr.wiki.processor.runtime.IWikiProcessor;
import jetbrains.mps.webr.wiki.processor.runtime.utils.HtmlConstants;
import jetbrains.mps.webr.wiki.processor.runtime.utils.StringUtils;

public class CommonWikiUtils {
    public static String valuableSubstring(String text, int begin, int end) {
        int endIdx;
        int beginIdx;
        if (begin >= end) {
            return "";
        }
        if (--end >= (beginIdx = CommonWikiUtils.indexOfValuebleSymbol(text, begin, end, 1)) && (beginIdx < (endIdx = CommonWikiUtils.indexOfValuebleSymbol(text, end, begin, -1)) || beginIdx == endIdx && text.charAt(beginIdx) != ' ')) {
            return text.substring(beginIdx, endIdx + 1);
        }
        return "";
    }

    public static String valuableSubstring(String text) {
        return CommonWikiUtils.valuableSubstring(text, 0, text.length());
    }

    public static String valuableSubstring(String text, char startSymbol, char stopSymbol) {
        return CommonWikiUtils.valuableSubstring(text, text.indexOf(startSymbol) + 1, text.indexOf(stopSymbol));
    }

    public static String valuableSubstring(String text, int beginIdx, char stopSymbol) {
        return CommonWikiUtils.valuableSubstring(text, beginIdx, text.indexOf(stopSymbol));
    }

    public static String valuableSubstring(String text, char startSymbol, int endIdx) {
        return CommonWikiUtils.valuableSubstring(text, text.charAt(startSymbol) + '\u0001', endIdx);
    }

    private static int indexOfValuebleSymbol(String text, int start, int stop, int direction) {
        int idx;
        for (idx = start; idx != stop && CommonWikiUtils.isWhitespace(text.charAt(idx)); idx += direction) {
        }
        if (CommonWikiUtils.isNewLine(text.charAt(idx))) {
            return idx + direction;
        }
        return start;
    }

    public static boolean isNewLine(char c) {
        return c == '\n' || c == '\r';
    }

    public static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    public static void appendEscapeCodeAlias(String text, TBaseBuilderContext context, IWikiProcessor processor) {
        if (SetSequence.fromSet(HtmlConstants.ESCAPE_CODE_ALIASES).contains((Object)text)) {
            context.append(text);
        } else {
            processor.clone(BaseProcessor.characterToStringSafe(text.charAt(0))).processSafe(context);
            processor.clone(StringUtils.substring(text, 1)).processSafe(context);
        }
    }
}

