/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.wiki.runtime.higlighter.java;

import java.util.regex.Pattern;
import jetbrains.mps.wiki.runtime.higlighter.java.LanguageHighlighter;

public class JavaHighlighter
extends LanguageHighlighter {
    private static String sample;
    private static Pattern REGEXP_dfe53z_a0a05a0;
    private static Pattern REGEXP_dfe53z_a0a15a0;
    private static Pattern REGEXP_dfe53z_a0a25a0;
    private static Pattern REGEXP_dfe53z_a0a35a0;
    private static Pattern REGEXP_dfe53z_a0a45a0;
    private static Pattern REGEXP_dfe53z_a0a55a0;

    public JavaHighlighter() {
        this.addKeyWord("abstract");
        this.addKeyWord("assert");
        this.addKeyWord("boolean");
        this.addKeyWord("break");
        this.addKeyWord("byte");
        this.addKeyWord("case");
        this.addKeyWord("catch");
        this.addKeyWord("char");
        this.addKeyWord("class");
        this.addKeyWord("const");
        this.addKeyWord("continue");
        this.addKeyWord("default");
        this.addKeyWord("do");
        this.addKeyWord("double");
        this.addKeyWord("else");
        this.addKeyWord("enum");
        this.addKeyWord("extends");
        this.addKeyWord("final");
        this.addKeyWord("finally");
        this.addKeyWord("float");
        this.addKeyWord("for");
        this.addKeyWord("goto");
        this.addKeyWord("if");
        this.addKeyWord("implements");
        this.addKeyWord("import");
        this.addKeyWord("instanceof");
        this.addKeyWord("int");
        this.addKeyWord("interface");
        this.addKeyWord("long");
        this.addKeyWord("native");
        this.addKeyWord("new");
        this.addKeyWord("package");
        this.addKeyWord("private");
        this.addKeyWord("protected");
        this.addKeyWord("public");
        this.addKeyWord("return");
        this.addKeyWord("short");
        this.addKeyWord("static");
        this.addKeyWord("strictfp");
        this.addKeyWord("super");
        this.addKeyWord("switch");
        this.addKeyWord("synchronized");
        this.addKeyWord("this");
        this.addKeyWord("throw");
        this.addKeyWord("throws");
        this.addKeyWord("transient");
        this.addKeyWord("try");
        this.addKeyWord("void");
        this.addKeyWord("volatile");
        this.addKeyWord("while");
        this.add(REGEXP_dfe53z_a0a05a0, "number");
        this.add(REGEXP_dfe53z_a0a15a0, "number");
        this.add(REGEXP_dfe53z_a0a25a0, "number");
        this.add(REGEXP_dfe53z_a0a35a0, "string");
        this.add(REGEXP_dfe53z_a0a45a0, "comment");
        this.add(REGEXP_dfe53z_a0a55a0, "comment");
    }

    @Override
    public String getLanguage() {
        return "java";
    }

    @Override
    protected String getSampleCode() {
        if (sample == null) {
            StringBuilder builder = new StringBuilder();
            builder.append("// Some java code\n");
            builder.append("for (int i = 0; i < 10; i++) {\n");
            builder.append("  System.out.println(\"Hello, \\\"World\\\"\");\n");
            builder.append("  /* with multiline\n");
            builder.append("     comments */\n");
            builder.append("}\n");
            sample = builder.toString();
        }
        return sample;
    }

    static {
        REGEXP_dfe53z_a0a05a0 = Pattern.compile("\\d+", 0);
        REGEXP_dfe53z_a0a15a0 = Pattern.compile("0[0-7]+", 0);
        REGEXP_dfe53z_a0a25a0 = Pattern.compile("0x[0-9A-Fa-f]", 0);
        REGEXP_dfe53z_a0a35a0 = Pattern.compile("\".*?[^\\\\](?:[\\\\][\\\\])*\"", 0);
        REGEXP_dfe53z_a0a45a0 = Pattern.compile("/\\*.*?\\*/", 32);
        REGEXP_dfe53z_a0a55a0 = Pattern.compile("//.*?$", 8);
    }
}

