/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.ring.servlet.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContextReplacer {
    public static final Pattern LINK_BEGIN_PATTERN = Pattern.compile("((.+?(src|href|content)=[\"'])(/[^\"']*?[\"']))", 2);
    static final String COMMENT_TAG_START = "<!-- ";
    static final String COMMENT_TAG_END = " -->";
    private final String startTag;
    private final String endTag;
    private final String contextPath;
    private StringBuilder builder;

    public ContextReplacer(String tagName, String contextPath) {
        this.contextPath = contextPath;
        this.startTag = COMMENT_TAG_START + tagName + COMMENT_TAG_END;
        this.endTag = "<!-- end" + tagName + COMMENT_TAG_END;
    }

    public void setBuilder(StringBuilder builder) {
        this.builder = builder;
    }

    private void replace(String content) {
        if (content == null) {
            return;
        }
        int length = content.length();
        if (length == 0) {
            return;
        }
        int idx = 0;
        int start = content.indexOf(this.startTag);
        while (start >= 0) {
            int end = content.indexOf(this.endTag, idx);
            if (end < start) {
                throw new RuntimeException("Invalid context tag at index: [" + start + ":" + end + "] Parsed: " + content.substring(0, start));
            }
            this.builder.append(content.substring(idx, start));
            String tagContent = content.substring(start + this.startTag.length(), end);
            this.builder.append(this.replaceTagContent(tagContent));
            idx = end + this.endTag.length();
            start = content.indexOf(this.startTag, idx);
        }
        this.builder.append(content.substring(idx, length));
    }

    public String replaceAll(String content) {
        StringBuilder stringBuilder = new StringBuilder();
        this.setBuilder(stringBuilder);
        this.replace(content);
        return stringBuilder.toString();
    }

    protected String replaceTagContent(String content) {
        Matcher m = LINK_BEGIN_PATTERN.matcher(content);
        StringBuffer buffer = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(buffer, "$2" + this.contextPath + "$4");
        }
        m.appendTail(buffer);
        return buffer.toString();
    }
}

