/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.ring.servlet.util;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import jetbrains.ring.servlet.LookupResult;
import jetbrains.ring.servlet.util.ServletUtil;

public class IndexFileHolder {
    private static final long LAST_MODIFIED = System.currentTimeMillis();
    private final URL url;
    private final String replacePattern;
    private final String contextTag;
    private final String cacheControl;
    private final ConcurrentHashMap<String, LookupResult.IndexResource> path2index = new ConcurrentHashMap(1);

    public IndexFileHolder(URL url, String replacePattern, String contextTag, String cacheControl) {
        this.url = url;
        this.replacePattern = replacePattern;
        this.contextTag = contextTag;
        this.cacheControl = cacheControl;
    }

    public LookupResult.IndexResource getIndexResource(HttpServletRequest request) throws IOException {
        return this.getIndexResource(ServletUtil.getServletPath(request));
    }

    protected LookupResult.IndexResource getIndexResource(String path) throws IOException {
        long lastModified = this.getLastModified();
        LookupResult.IndexResource resource = this.path2index.get(path);
        if (resource == null) {
            LookupResult.IndexResource res = this.createIndexResource(this.url, lastModified, this.replacePattern, this.contextTag, path);
            res.setCacheControl(this.cacheControl);
            resource = this.path2index.putIfAbsent(path, res);
            if (resource == null) {
                resource = res;
            }
        }
        return resource;
    }

    protected LookupResult.IndexResource createIndexResource(URL url, long lastModified, String replacePattern, String contextTag, String contextPath) throws IOException {
        return new LookupResult.IndexResource(url, lastModified, replacePattern, contextTag, contextPath);
    }

    protected long getLastModified() {
        return LAST_MODIFIED;
    }
}

