/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.teamsys.dnq.runtime.files;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.teamsys.dnq.runtime.files.PersistentFileImpl;
import jetbrains.teamsys.dnq.runtime.files.StringUtils;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileMeta {
    public static double MAX_RESAMPLING_RATIO = 0.05;
    protected static Log log = LogFactory.getLog(FileMeta.class);
    private long size = -1L;
    private String mimeType = null;
    private String format = null;
    private String name = null;

    public FileMeta(Entity file) {
        this.size = (Long)PrimitiveAssociationSemantics.get((Entity)file, (String)"size", Long.class, null);
        this.mimeType = FileMeta.stripMimeTypeSubHeaders((String)PrimitiveAssociationSemantics.get((Entity)file, (String)"mimeType", String.class, null));
        this.name = (String)PrimitiveAssociationSemantics.get((Entity)file, (String)"name", String.class, null);
        this.format = this.getImageWriterFormat();
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFormat() {
        return this.format;
    }

    public String getName() {
        return this.name;
    }

    public void usePngAsDefault() {
        if (this.format == null) {
            this.format = "PNG";
            this.mimeType = "image/png";
            this.name = FilenameUtils.removeExtension((String)this.name) + ".png";
        }
    }

    private String getImageWriterFormat() {
        Iterator<ImageWriter> imageWriters;
        String writerFormatName = null;
        if (FileMeta.isNotEmpty_tyrzkw_a0b0g(this.mimeType) && (imageWriters = ImageIO.getImageWritersByMIMEType(this.mimeType)).hasNext()) {
            ImageWriter imageWriter = imageWriters.next();
            String[] formatNames = imageWriter.getOriginatingProvider().getFormatNames();
            if (formatNames.length > 0) {
                writerFormatName = formatNames[0];
            }
            imageWriter.dispose();
        }
        return writerFormatName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension countDimension(Entity file) {
        String type;
        InputStream content = PrimitiveAssociationSemantics.getBlob((Entity)file, (String)"content");
        if (content != null && FileMeta.mimeTypeIsImage(type = ((PersistentFileImpl)DnqUtils.getPersistentClassInstance(file, "PersistentFile")).getMimeType(file))) {
            try {
                Iterator<ImageReader> imageReaders = ImageIO.getImageReadersByMIMEType(type);
                while (true) {
                    if (!imageReaders.hasNext()) break;
                    ImageReader reader = imageReaders.next();
                    try {
                        ImageInputStream stream = ImageIO.createImageInputStream(content);
                        reader.setInput(stream);
                        int width = reader.getWidth(reader.getMinIndex());
                        int height = reader.getHeight(reader.getMinIndex());
                        Dimension dimension = new Dimension(width, height);
                        reader.dispose();
                        return dimension;
                    }
                    catch (IOException e) {
                        try {
                            try {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Can't calculate dimension for file [" + (String)PrimitiveAssociationSemantics.get((Entity)file, (String)"name", String.class, null) + "] as mime type " + type), (Throwable)e);
                                }
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                reader.dispose();
                            }
                            content.close();
                            if ((content = PrimitiveAssociationSemantics.getBlob((Entity)file, (String)"content")) != null) continue;
                            if (log.isErrorEnabled()) {
                                log.error((Object)("Repeatable read of file.content returs null for file " + file));
                            }
                        }
                        catch (Exception e2) {
                            if (log.isErrorEnabled()) {
                                log.error((Object)"Error while reading an image (possible unknown image type)", (Throwable)e2);
                            }
                        }
                    }
                    break;
                }
            }
            finally {
                try {
                    if (content != null) {
                        content.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return new Dimension(-1, -1);
    }

    public static String stripMimeTypeSubHeaders(String mimeType) {
        if (mimeType == null || mimeType.length() == 0) {
            return mimeType;
        }
        int index = mimeType.indexOf(59);
        if (index < 0) {
            return mimeType;
        }
        return StringUtils.substring(mimeType, 0, index);
    }

    public static boolean mimeTypeIsImage(String mimeType) {
        return mimeType.startsWith("image/");
    }

    public static boolean isNotEmpty_tyrzkw_a0b0g(String str) {
        return str != null && str.length() > 0;
    }
}

