/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.teamsys.dnq.runtime.util;

import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import com.jetbrains.teamsys.dnq.database.TransientEntityStoreImpl;
import com.jetbrains.teamsys.dnq.database.TransientStoreUtil;
import java.util.Map;
import java.util.Set;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.database.EntityCreator;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.database.TransientStoreSessionListener;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EventsMultiplexer;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.metadata.EntityMetaData;
import jetbrains.exodus.query.metadata.ModelMetaData;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.eventsCompat.EventsMultiplexerLegacy;
import jetbrains.teamsys.dnq.runtime.queries.EnumConst;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.TransientQueryCancellingPolicyProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DnqUtils {
    private static final Map<String, EnumConst.Container> ENUM_METADATA = new HashMap();
    protected static Log log = LogFactory.getLog(DnqUtils.class);

    private DnqUtils() {
    }

    public static void initModelMetaData() {
        DnqUtils.initModelMetaData(false);
    }

    public static void initModelMetaData(boolean postponeUniqueIndexes) {
        TransientStoreUtil.setPostponeUniqueIndexes((boolean)postponeUniqueIndexes);
        ((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore")).setModelMetaData((ModelMetaData)ServiceLocator.getBean((String)"modelMetaData"));
        DnqUtils.executeInitializers();
        if (!postponeUniqueIndexes) {
            DnqUtils.initUniqueProperties();
        }
        DnqUtils.initEventsMultiplexer();
    }

    private static void executeInitializers() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Execute entities initializers");
        }
        _Txn.run(new _FunctionTypes._void_P0_E0(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invoke() {
                TransientEntityStore store = (TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore");
                Iterable entitiesMetaData = ((ModelMetaData)ServiceLocator.getBean((String)"modelMetaData")).getEntitiesMetaData();
                for (EntityMetaData emd : Sequence.fromIterable((Iterable)entitiesMetaData)) {
                    Runnable classInitializer = emd.getInitializer();
                    if (classInitializer == null) continue;
                    if (classInitializer instanceof BasePersistentClassImpl) {
                        ((BasePersistentClassImpl)classInitializer).setEntityStore(store);
                    }
                    classInitializer.run();
                }
                for (EntityMetaData emd : Sequence.fromIterable((Iterable)entitiesMetaData)) {
                    EnumConst.Container enumInitializer;
                    Map map = ENUM_METADATA;
                    synchronized (map) {
                        enumInitializer = (EnumConst.Container)ENUM_METADATA.get(emd.getType());
                    }
                    if (enumInitializer == null) continue;
                    EnumConst.initContainer(enumInitializer);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearEnumMetaData() {
        Map<String, EnumConst.Container> map = ENUM_METADATA;
        synchronized (map) {
            ENUM_METADATA.clear();
        }
    }

    public static void initUniqueProperties() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Init indexes for unique properties and composite keys");
        }
        try {
            HashSet indexes = new HashSet();
            for (EntityMetaData emd : Sequence.fromIterable((Iterable)((ModelMetaData)ServiceLocator.getBean((String)"modelMetaData")).getEntitiesMetaData())) {
                indexes.addAll(emd.getIndexes());
            }
            ((QueryEngine)ServiceLocator.getBean((String)"queryEngine")).getUniqueKeyIndicesEngine().updateUniqueKeyIndices((Iterable)indexes);
            TransientStoreUtil.setPostponeUniqueIndexes((boolean)false);
        }
        catch (RuntimeException e) {
            DnqUtils.removeUniquePropertyIndexes();
            throw e;
        }
    }

    public static void removeUniquePropertyIndexes() {
        ((QueryEngine)ServiceLocator.getBean((String)"queryEngine")).getUniqueKeyIndicesEngine().updateUniqueKeyIndices((Iterable)new HashSet());
    }

    private static void initEventsMultiplexer() {
        EventsMultiplexer em = EventsMultiplexerLegacy.getInstance();
        if (em != null) {
            ((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore")).addListener((TransientStoreSessionListener)em);
        }
    }

    public static TransientStoreSession getCurrentTransientSession() {
        return DnqUtils.getTransientStore().getThreadSession();
    }

    public static TransientEntityStore getTransientStore() {
        return (TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore");
    }

    public static StoreTransaction getCurrentPersistentSession() {
        return ((PersistentEntityStore)ServiceLocator.getBean((String)"persistentEntityStore")).getCurrentTransaction();
    }

    public static ModelMetaData getModelMetaData() {
        return DnqUtils.getTransientStore().getModelMetaData();
    }

    public static TransientStoreSession beginTransientSession() {
        return DnqUtils.beginSession(false);
    }

    public static TransientStoreSession beginReadonlyTransientSession() {
        return DnqUtils.beginSession(true);
    }

    private static TransientStoreSession beginSession(boolean readonly) {
        TransientStoreSession result = null;
        try {
            TransientEntityStore store = DnqUtils.getTransientStore();
            result = readonly ? store.beginReadonlyTransaction() : store.beginSession();
            DnqUtils.computePolicy(result);
        }
        catch (RuntimeException ex) {
            if (result != null) {
                try {
                    result.abort();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            throw ex;
        }
        return result;
    }

    public static TransientStoreSession suspendCurrentTransientSession() {
        return DnqUtils.getTransientStore().suspendThreadSession();
    }

    public static void resumeTransientSession(TransientStoreSession session) {
        DnqUtils.getTransientStore().resumeSession(session);
        DnqUtils.computePolicy(session);
    }

    public static void setPersistentClassInstance(String entityType, BasePersistentClassImpl instance) {
        ((TransientEntityStoreImpl)DnqUtils.getTransientStore()).setCachedPersistentClassInstance(entityType, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPersistentEnumContainer(String entityType, EnumConst.Container container) {
        Map<String, EnumConst.Container> map = ENUM_METADATA;
        synchronized (map) {
            if (ENUM_METADATA.get(entityType) == null) {
                ENUM_METADATA.put(entityType, container);
            }
        }
    }

    public static BasePersistentClassImpl getPersistentClassInstance(Entity e, String entityType) {
        String type;
        TransientEntityStore store;
        if (e == null) {
            store = DnqUtils.getTransientStore();
            type = entityType;
        } else {
            store = e.getStore();
            type = e.getType();
        }
        return ((TransientEntityStoreImpl)store).getCachedPersistentClassInstance(type);
    }

    public static boolean _instanceOf(Object o, String type) {
        if (!(o instanceof Entity)) {
            return false;
        }
        return DnqUtils.isTypeOf(((Entity)o).getType(), type);
    }

    public static boolean isTypeOf(String type, String ofType) {
        EntityMetaData emd;
        if (type == null) {
            return false;
        }
        ModelMetaData mmd = DnqUtils.getModelMetaData();
        do {
            if (type.equals(ofType)) {
                return true;
            }
            emd = mmd.getEntityMetaData(type);
            if (emd == null) break;
            for (String iFace : emd.getInterfaceTypes()) {
                if (!iFace.equals(ofType)) continue;
                return true;
            }
        } while ((type = emd.getSuperType()) != null);
        return false;
    }

    public static Entity cast(Object e, String toType) {
        if (e == null) {
            return null;
        }
        if (DnqUtils._instanceOf(e, toType)) {
            return (Entity)e;
        }
        throw new ClassCastException(e.toString() + "' cannot be cast to Entity of type '" + toType + "'");
    }

    public static Entity as(Object e, String asType) {
        return DnqUtils._instanceOf(e, asType) ? (Entity)e : null;
    }

    public static PersistentEntityId toPersistentId(Entity entity) {
        return EntityOperations.equals((Entity)entity, null) ? null : new PersistentEntityId(entity.getId());
    }

    public static Entity fromPersistentId(PersistentEntityId id) {
        return id == null ? null : DnqUtils.getCurrentTransientSession().getEntity((EntityId)id);
    }

    public static String getTransactionsDump() {
        StringBuilder sb = new StringBuilder("\n==================[dnq transient sessions dump]=================");
        ((TransientEntityStoreImpl)((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore"))).dumpSessions(sb);
        return sb.append("\n====================================================").toString();
    }

    private static void computePolicy(TransientStoreSession session) {
        TransientQueryCancellingPolicyProvider provider;
        if (session != null && (provider = (TransientQueryCancellingPolicyProvider)ServiceLocator.getOptionalBean((String)"transientQueryCancellingPolicyProvider")) != null) {
            session.setQueryCancellingPolicy(provider.getQueryCancellingPolicy());
        }
    }

    public static QueryingEntityCreator getEntityCreator(final String entityType, Set<String> queriedParams) {
        return new QueryingEntityCreator(entityType){

            @Override
            public Iterable<Entity> query() {
                return QueryOperations.queryGetAll(entityType);
            }

            public void created(Entity p0) {
            }
        };
    }

    public static abstract class QueryingEntityCreator
    extends EntityCreator {
        protected QueryingEntityCreator(String type) {
            super(type);
        }

        public Entity find() {
            return QueryOperations.getFirst(this.query());
        }

        public abstract Iterable<Entity> query();

        public Entity create(TransientEntityStore store) {
            return store.getThreadSession().newEntity((EntityCreator)this);
        }
    }
}

