/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.teamsys.dnq.runtime.util;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;

public class EntityFactory {
    public Entity getOrCreate(String fqName) {
        if (fqName.length() < 4) {
            throw new IllegalArgumentException("Name too short");
        }
        if (!fqName.endsWith("Impl")) {
            throw new IllegalArgumentException("Name seems to be not of persistent classifier type");
        }
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(fqName);
            String simpleName = clazz.getSimpleName();
            Entity result = QueryOperations.getFirst((Iterable<Entity>)QueryOperations.queryGetAll(simpleName.substring(0, simpleName.length() - 4)));
            if (EntityOperations.equals((Entity)result, null)) {
                result = (Entity)clazz.getMethod("constructor", new Class[0]).invoke(null, new Object[0]);
                DnqUtils.getCurrentTransientSession().flush();
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Entity getOrCreateIsolated(final String fqName) {
        return _Txn.evalNew(new _FunctionTypes._return_P0_E0<Entity>(){

            public Entity invoke() {
                return EntityFactory.this.getOrCreate(fqName);
            }
        });
    }
}

