/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.teamsys.license.runtime;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import jetbrains.teamsys.license.runtime.LicenseUtil;

public class LicenseGenerator {
    private final BigInteger p;
    private final BigInteger q;
    private BigInteger license;
    private int licenseBitLen;

    public LicenseGenerator(BigInteger p, BigInteger q) {
        this.p = p;
        this.q = q;
    }

    public void beginGeneration(String username, int productType, int productVersion, int productMinorVersion, int buildNumber, int licenseType, long expirationTime) throws GeneralSecurityException {
        this.license = LicenseUtil.getUsernameMD5(username);
        this.licenseBitLen = 128;
        if (expirationTime <= 0L) {
            throw new ArithmeticException("Bad expiration time");
        }
        this.addValue(productType, 16);
        this.addBroadcastableValue(productVersion, 10, Integer.MAX_VALUE);
        this.addBroadcastableValue(productMinorVersion, 10, Integer.MAX_VALUE);
        this.addBroadcastableValue(buildNumber, 20, Integer.MAX_VALUE);
        this.addValue(licenseType, 4);
        this.addValue(System.currentTimeMillis(), 63);
        this.addValue(expirationTime, 63);
    }

    public void addValue(long value, int bitLen) {
        if (bitLen < 63 && (value < 0L || value >= LicenseUtil.powerOf2(bitLen))) {
            throw new IllegalArgumentException("value is out of bit range");
        }
        this.license = this.license.or(BigInteger.valueOf(value).shiftLeft(this.licenseBitLen));
        this.licenseBitLen += bitLen;
    }

    public void addBroadcastableValue(long value, int bitLen, long broadcastValue) {
        this.addValue(value == broadcastValue ? LicenseUtil.powerOf2(bitLen) - 1L : value, bitLen);
    }

    public void endGeneration() throws GeneralSecurityException {
        this.license = LicenseUtil.getLicenseMD5(this.license).or(this.license.shiftLeft(128));
        BigInteger phi = this.p.subtract(LicenseUtil.ONE).multiply(this.q.subtract(LicenseUtil.ONE));
        BigInteger oneThird = LicenseUtil.THREE.modInverse(phi);
        BigInteger n = this.p.multiply(this.q);
        this.license = this.license.modPow(oneThird, n);
    }

    public BigInteger getLicense() {
        return this.license;
    }

    public String getLicenseString() {
        return this.license.toString(16);
    }
}

