/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internal.collections.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import jetbrains.mps.baseLanguage.closures.runtime.AdapterClass;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ArrayUtils;
import jetbrains.mps.internal.collections.runtime.CollectionSequence;
import jetbrains.mps.internal.collections.runtime.CollectionUtils;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.impl.NullListSequence;

public class ListSequence<T>
extends CollectionSequence<T>
implements IListSequence<T>,
List<T>,
Serializable {
    private static final long serialVersionUID = 8593660517992105071L;
    private List<T> list;

    protected ListSequence(List<T> list) {
        this.setList(list);
    }

    protected ListSequence(ListSequence<T> other) {
        this.setList(new ArrayList<T>(other.getList()));
    }

    @Override
    public void add(int index, T element) {
        this.getList().add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.getList().addAll(index, c);
    }

    @Override
    public int indexOf(Object o) {
        return this.getList().indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    @Override
    public T get(int index) {
        return this.getList().get(index);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getList().lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.getList().listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.getList().listIterator(index);
    }

    @Override
    public T remove(int index) {
        return this.getList().remove(index);
    }

    @Override
    public T set(int index, T element) {
        return this.getList().set(index, element);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.getList().subList(fromIndex, toIndex);
    }

    @Override
    public T first() {
        if (this.getList().size() > 0) {
            return this.getList().get(0);
        }
        return null;
    }

    @Override
    public T last() {
        if (this.getList().size() > 0) {
            return this.getList().get(this.getList().size() - 1);
        }
        return null;
    }

    @Override
    public boolean isNotEmpty() {
        return !this.getList().isEmpty();
    }

    @Override
    public T removeElementAt(int idx) {
        if (this.size() == 0 && (idx == 0 || idx == -1)) {
            return null;
        }
        return this.remove(idx);
    }

    @Override
    public T removeLastElement() {
        if (this.size() == 0) {
            return null;
        }
        return this.remove(this.size() - 1);
    }

    @Override
    public T insertElement(int idx, T t) {
        this.add(idx, t);
        return t;
    }

    @Override
    public T getElement(int idx) {
        if (this.size() == 0 && (idx == 0 || idx == -1)) {
            return null;
        }
        return this.get(idx);
    }

    @Override
    public T setElement(int idx, T t) {
        if (this.size() == 0 && (idx == 0 || idx == -1)) {
            return null;
        }
        this.set(idx, t);
        return t;
    }

    @Override
    public IListSequence<T> addSequence(ISequence<? extends T> seq) {
        return (IListSequence)super.addSequence(seq);
    }

    @Override
    public IListSequence<T> removeSequence(ISequence<? extends T> seq) {
        return (IListSequence)super.removeSequence(seq);
    }

    @Override
    public IListSequence<T> removeWhere(@AdapterClass(value="IWhereFilter") _FunctionTypes._return_P1_E0<? extends Boolean, ? super T> filter) {
        return (IListSequence)super.removeWhere(filter);
    }

    @Override
    public IListSequence<T> reversedList() {
        ListSequence<T> reversed = new ListSequence<T>(this);
        reversed._reverse();
        return reversed;
    }

    @Override
    public IListSequence<T> subListSequence(int fromIdx, int upToIdx) {
        return new ListSequence<T>(this.getList().subList(fromIdx, upToIdx));
    }

    @Override
    public IListSequence<T> headListSequence(int upToIdx) {
        return new ListSequence<T>(this.getList().subList(0, upToIdx));
    }

    @Override
    public IListSequence<T> tailListSequence(int fromIdx) {
        return new ListSequence<T>(this.getList().subList(fromIdx, this.getList().size()));
    }

    @Override
    public IListSequence<T> asUnmodifiable() {
        return new ListSequence<T>(Collections.unmodifiableList(this.getList()));
    }

    @Override
    public IListSequence<T> asSynchronized() {
        return new ListSequence<T>(CollectionUtils.synchronizedList(this.getList()));
    }

    @Override
    public T[] toGenericArray() {
        return this.getList().toArray();
    }

    @Override
    public T[] toGenericArray(Class<T> runtimeClass) {
        Object[] arr = (Object[])ArrayUtils.newArrayInstance(runtimeClass, this.getList().size());
        return this.getList().toArray(arr);
    }

    @Override
    public List<T> toList() {
        return this;
    }

    @Override
    public IListSequence<T> toListSequence() {
        return this;
    }

    void _reverse() {
        Collections.reverse(this.getList());
    }

    @Override
    protected List<T> getCollection() {
        return this.list;
    }

    protected List<T> getList() {
        return this.list;
    }

    private void setList(List<T> list) {
        this.list = list;
    }

    public static <U> IListSequence<U> fromArray(U ... array) {
        if (array == null) {
            return NullListSequence.instance();
        }
        return ListSequence.fromListAndArray(new ArrayList(), array);
    }

    public static <U> IListSequence<U> fromList(List<U> list) {
        if (list == null) {
            return NullListSequence.instance();
        }
        if (list instanceof IListSequence) {
            return (IListSequence)list;
        }
        return new ListSequence<U>(list);
    }

    public static <U> IListSequence<U> fromListAndArray(List<U> list, U ... array) {
        if (array == null) {
            array = Sequence.nullSingletonArray();
        }
        if (list == null && array == null) {
            return NullListSequence.instance();
        }
        if (list == null) {
            list = new ArrayList<U>();
        } else if (array == null) {
            if (list instanceof IListSequence) {
                return (IListSequence)list;
            }
            return new ListSequence<U>(list);
        }
        List<U> input = Arrays.asList(array);
        list.addAll(input);
        if (list instanceof IListSequence) {
            return (IListSequence)list;
        }
        return new ListSequence<U>(list);
    }

    public static <U> IListSequence<U> fromIterable(Iterable<U> it) {
        if (it == null) {
            return NullListSequence.instance();
        }
        if (it instanceof IListSequence) {
            return (IListSequence)it;
        }
        ArrayList<U> list = new ArrayList<U>();
        if (it instanceof Collection) {
            list.addAll((Collection)it);
        } else {
            for (U u : it) {
                list.add(u);
            }
        }
        return new ListSequence(list);
    }

    public static <U> IListSequence<U> fromListWithValues(List<U> list, Iterable<? extends U> it) {
        List<U> tmp = list;
        if (list == null && it == null) {
            return NullListSequence.instance();
        }
        if (list == null) {
            tmp = new ArrayList<U>();
        } else if (it == null) {
            return ListSequence.fromList(list);
        }
        if (it instanceof Collection) {
            tmp.addAll((Collection)it);
        } else {
            for (U u : it) {
                tmp.add(u);
            }
        }
        if (tmp instanceof IListSequence) {
            return (IListSequence)tmp;
        }
        return new ListSequence<U>(tmp);
    }
}

