/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internal.collections.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import jetbrains.mps.baseLanguage.closures.runtime.AdapterClass;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IEnumerator;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.SelectComparator;
import jetbrains.mps.internal.collections.runtime.impl.BasicSequence;
import jetbrains.mps.internal.collections.runtime.impl.ComparingSequence;
import jetbrains.mps.internal.collections.runtime.impl.ConcatingSequence;
import jetbrains.mps.internal.collections.runtime.impl.EnumeratorIterator;
import jetbrains.mps.internal.collections.runtime.impl.FilteringSequence;
import jetbrains.mps.internal.collections.runtime.impl.LimitedCardinalitySequence;
import jetbrains.mps.internal.collections.runtime.impl.NegateWhereFilter;
import jetbrains.mps.internal.collections.runtime.impl.NullSequence;
import jetbrains.mps.internal.collections.runtime.impl.NullSetSequence;
import jetbrains.mps.internal.collections.runtime.impl.OfTypeSequence;
import jetbrains.mps.internal.collections.runtime.impl.PagingSequence;
import jetbrains.mps.internal.collections.runtime.impl.ReversingSequence;
import jetbrains.mps.internal.collections.runtime.impl.SelectingSequence;
import jetbrains.mps.internal.collections.runtime.impl.SortingSequence;
import jetbrains.mps.internal.collections.runtime.impl.TranslatingSequence;

public abstract class Sequence<T>
implements ISequence<T>,
Iterable<T> {
    public static final boolean USE_NULL_SEQUENCE = true;
    public static final boolean IGNORE_NULL_VALUES = false;
    public static final boolean NULL_WHEN_EMPTY = true;
    public static final boolean NULL_ARRAY_IS_SINGLETON = true;
    protected static final Object[] ARRAY_WITH_NULL = new Object[]{null};

    @Override
    public ISequence<T> where(@AdapterClass(value="IWhereFilter") _FunctionTypes._return_P1_E0<? extends Boolean, ? super T> filter) {
        return new FilteringSequence<T>(this, filter);
    }

    @Override
    public T findFirst(@AdapterClass(value="IWhereFilter") _FunctionTypes._return_P1_E0<? extends Boolean, ? super T> filter) {
        return this.where(filter).first();
    }

    @Override
    public T findLast(@AdapterClass(value="IWhereFilter") _FunctionTypes._return_P1_E0<? extends Boolean, ? super T> filter) {
        return this.where(filter).last();
    }

    @Override
    public boolean any(@AdapterClass(value="IWhereFilter") _FunctionTypes._return_P1_E0<? extends Boolean, ? super T> filter) {
        return this.where(filter).isNotEmpty();
    }

    @Override
    public boolean all(@AdapterClass(value="IWhereFilter") _FunctionTypes._return_P1_E0<? extends Boolean, ? super T> filter) {
        return this.where(new NegateWhereFilter<T>(filter)).isEmpty();
    }

    @Override
    public <U> ISequence<U> translate(@AdapterClass(value="ITranslator2") _FunctionTypes._return_P1_E0<? extends Iterable<U>, ? super T> translator) {
        return new TranslatingSequence(this, translator);
    }

    @Override
    public <U> ISequence<U> select(@AdapterClass(value="ISelector") _FunctionTypes._return_P1_E0<? extends U, ? super T> selector) {
        return new SelectingSequence<T, U>(this, selector);
    }

    @Override
    public <U> ISequence<U> ofType(Class<U> type) {
        return new OfTypeSequence(this, type);
    }

    @Override
    public ISequence<T> sort(@AdapterClass(value="ISelector") _FunctionTypes._return_P1_E0<? extends Comparable<?>, ? super T> selector, boolean ascending) {
        return new SortingSequence<T>(this, new SelectComparator<T>(selector), ascending);
    }

    @Override
    public ISequence<T> alsoSort(@AdapterClass(value="ISelector") _FunctionTypes._return_P1_E0<? extends Comparable<?>, ? super T> selector, boolean ascending) {
        return this.sort(selector, ascending);
    }

    @Override
    public ISequence<T> sort(Comparator<T> comparator, boolean ascending) {
        return new SortingSequence<T>(this, comparator, ascending);
    }

    @Override
    public ISequence<T> distinct() {
        return new LimitedCardinalitySequence(this, 1);
    }

    @Override
    public void visitAll(@AdapterClass(value="IVisitor") _FunctionTypes._void_P1_E0<? super T> visitor) {
        IterableUtils.visitAll(this.toIterable(), visitor);
    }

    @Override
    public ISequence<T> take(int length) {
        return new PagingSequence(this, PagingSequence.Page.TAKE, length);
    }

    @Override
    public ISequence<T> skip(int length) {
        return new PagingSequence(this, PagingSequence.Page.SKIP, length);
    }

    @Override
    public ISequence<T> cut(int length) {
        return new PagingSequence(this, PagingSequence.Page.CUT, length);
    }

    @Override
    public ISequence<T> tail(int length) {
        return new PagingSequence(this, PagingSequence.Page.TAIL, length);
    }

    @Override
    public ISequence<T> page(int skip, int skipplustake) {
        int take = skipplustake - skip;
        return this.skip(skip).take(take);
    }

    @Override
    public ISequence<T> concat(ISequence<T> that) {
        if (that == null) {
            return this;
        }
        return new ConcatingSequence<T>(this, that);
    }

    @Override
    public ISequence<T> intersect(ISequence<T> that) {
        if (that == null) {
            return NullSequence.instance();
        }
        return new ComparingSequence<T>(this, that, ComparingSequence.Kind.INTERSECTION);
    }

    @Override
    public ISequence<T> subtract(ISequence<T> that) {
        if (that == null) {
            return this;
        }
        return new ComparingSequence<T>(this, that, ComparingSequence.Kind.SUBSTRACTION);
    }

    @Override
    public ISequence<T> union(ISequence<T> that) {
        if (that == null) {
            return this;
        }
        return new ComparingSequence<T>(this, that, ComparingSequence.Kind.UNION);
    }

    @Override
    public ISequence<T> disjunction(ISequence<T> that) {
        if (that == null) {
            return this;
        }
        return new ComparingSequence<T>(this, that, ComparingSequence.Kind.DISJUNCTION);
    }

    @Override
    public ISequence<T> reverse() {
        return new ReversingSequence(this);
    }

    @Override
    public boolean contains(T t) {
        return IterableUtils.contains(this.toIterable(), t);
    }

    @Override
    public boolean containsSequence(ISequence<T> that) {
        if (that == null) {
            return false;
        }
        return that.subtract(this).isEmpty();
    }

    @Override
    public int indexOf(T t) {
        return IterableUtils.indexOf(this.toIterable(), t);
    }

    @Override
    public int lastIndexOf(T t) {
        return IterableUtils.lastIndexOf(this.toIterable(), t);
    }

    @Override
    public int count() {
        return IterableUtils.count(this.toIterable());
    }

    @Override
    public boolean isEmpty() {
        return IterableUtils.isEmpty(this.toIterable());
    }

    @Override
    public boolean isNotEmpty() {
        return IterableUtils.isNotEmpty(this.toIterable());
    }

    @Override
    public T first() {
        return IterableUtils.first(this.toIterable());
    }

    @Override
    public T last() {
        return IterableUtils.last(this.toIterable());
    }

    @Override
    public T reduceLeft(_FunctionTypes._return_P2_E0<? extends T, ? super T, ? super T> comb) {
        return IterableUtils.reduceLeft(this, comb);
    }

    @Override
    public T reduceRight(_FunctionTypes._return_P2_E0<? extends T, ? super T, ? super T> comb) {
        return IterableUtils.reduceRight(this.reverse(), comb);
    }

    @Override
    public <S> S foldLeft(S seed, _FunctionTypes._return_P2_E0<? extends S, ? super S, ? super T> comb) {
        return IterableUtils.foldLeft(this, seed, comb);
    }

    @Override
    public <S> S foldRight(S seed, _FunctionTypes._return_P2_E0<? extends S, ? super T, ? super S> comb) {
        return IterableUtils.foldRight(this.reverse(), seed, comb);
    }

    @Override
    public Iterable<T> toIterable() {
        return this;
    }

    @Override
    public IListSequence<T> toListSequence() {
        return ListSequence.fromIterable(this.toIterable());
    }

    @Override
    public T[] toGenericArray() {
        return this.toListSequence().toGenericArray();
    }

    @Override
    public T[] toGenericArray(Class<T> runtimeClass) {
        return this.toListSequence().toGenericArray(runtimeClass);
    }

    @Override
    public IEnumerator<T> enumerator() {
        return EnumeratorIterator.fromIterator(this.toIterable().iterator());
    }

    public String toString() {
        Iterable<T> iterable = this.toIterable();
        if (iterable == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("[");
        String sep = "";
        for (T t : iterable) {
            sb.append(sep).append(String.valueOf(t));
            sep = ", ";
        }
        sb.append("]");
        return sb.toString();
    }

    protected static <U> U[] nullSingletonArray() {
        return ARRAY_WITH_NULL;
    }

    public static <U> ISequence<U> emptySequence() {
        return NullSetSequence.instance();
    }

    public static <U> ISequence<U> fromArray(U ... array) {
        if (array == null) {
            return NullSequence.instance();
        }
        return new BasicSequence<U>(Arrays.asList(array));
    }

    public static <U> ISequence<U> fromClosure(@AdapterClass(value="ISequenceClosure") _FunctionTypes._return_P0_E0<? extends Iterable<U>> cls) {
        return Sequence.fromIterable((Iterable)cls.invoke());
    }

    public static <U> ISequence<U> fromIterable(Iterable<U> iterable) {
        if (iterable == null) {
            return NullSequence.instance();
        }
        if (iterable instanceof ISequence) {
            return (ISequence)iterable;
        }
        return new BasicSequence<U>(iterable);
    }

    public static <U> ISequence<U> singleton(U value) {
        return new BasicSequence<U>(Collections.singleton(value));
    }
}

