/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internal.collections.runtime;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jetbrains.mps.internal.collections.runtime.ArrayUtils;
import jetbrains.mps.internal.collections.runtime.CollectionSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.impl.NullSetSequence;

public class SetSequence<T>
extends CollectionSequence<T>
implements ISetSequence<T>,
Set<T>,
Serializable {
    private static final long serialVersionUID = -5489490742621116508L;
    private Set<T> set;

    protected SetSequence(Set<T> set) {
        this.set = set;
    }

    protected SetSequence(SetSequence<T> other) {
        this.set = new HashSet<T>(other.set);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.set.addAll(c);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.set).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.set).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.set.iterator();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.set.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.set.retainAll(c);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.set.toArray(a);
    }

    @Override
    public int count() {
        return this.set.size();
    }

    @Override
    public ISequence<T> disjunction(ISequence<T> that) {
        return super.disjunction(that);
    }

    @Override
    public ISequence<T> distinct() {
        return this;
    }

    @Override
    public ISequence<T> intersect(ISequence<T> that) {
        return super.intersect(that);
    }

    @Override
    public boolean isNotEmpty() {
        return this.count() > 0;
    }

    @Override
    public ISequence<T> subtract(ISequence<T> that) {
        return super.subtract(that);
    }

    @Override
    public ISequence<T> union(ISequence<T> that) {
        return super.union(that);
    }

    @Override
    public ISetSequence<T> addSequence(ISequence<? extends T> seq) {
        if (seq == null) {
            return this;
        }
        for (T t : seq.toIterable()) {
            this.set.add(t);
        }
        return this;
    }

    @Override
    public ISetSequence<T> removeSequence(ISequence<? extends T> seq) {
        if (seq == null) {
            return this;
        }
        for (T t : seq.toIterable()) {
            this.set.remove(t);
        }
        return this;
    }

    @Override
    public T[] toGenericArray() {
        return this.set.toArray();
    }

    @Override
    public T[] toGenericArray(Class<T> runtimeClass) {
        Object[] arr = (Object[])ArrayUtils.newArrayInstance(runtimeClass, this.set.size());
        return this.set.toArray(arr);
    }

    @Override
    public Set<T> toSet() {
        return this.set;
    }

    @Override
    public ISetSequence<T> asUnmodifiable() {
        return new SetSequence<T>(Collections.unmodifiableSet(this.getSet()));
    }

    @Override
    public ISetSequence<T> asSynchronized() {
        return new SetSequence<T>(Collections.unmodifiableSet(this.getSet()));
    }

    protected Set<T> getSet() {
        return this.set;
    }

    @Override
    protected Collection<T> getCollection() {
        return this.set;
    }

    public static <U> ISetSequence<U> fromArray(U ... array) {
        if (array == null) {
            return NullSetSequence.instance();
        }
        return SetSequence.fromSetAndArray(new HashSet(), array);
    }

    public static <U> ISetSequence<U> fromSet(Set<U> set) {
        if (set == null) {
            return NullSetSequence.instance();
        }
        if (set instanceof ISetSequence) {
            return (ISetSequence)set;
        }
        return new SetSequence<U>(set);
    }

    public static <U> ISetSequence<U> fromSetAndArray(Set<U> set, U ... array) {
        if (array == null) {
            array = Sequence.nullSingletonArray();
        }
        if (set == null && array == null) {
            return NullSetSequence.instance();
        }
        if (set == null) {
            set = new HashSet<U>();
        } else if (array == null) {
            if (set instanceof ISetSequence) {
                return (ISetSequence)set;
            }
            return new SetSequence<U>(set);
        }
        List<U> input = Arrays.asList(array);
        set.addAll(input);
        if (set instanceof ISetSequence) {
            return (ISetSequence)set;
        }
        return new SetSequence<U>(set);
    }

    public static <U> ISetSequence<U> fromIterable(Iterable<U> it) {
        if (it == null) {
            return NullSetSequence.instance();
        }
        if (it instanceof ISetSequence) {
            return (ISetSequence)it;
        }
        HashSet<U> set = new HashSet<U>();
        if (it instanceof Collection) {
            set.addAll((Collection)it);
        } else {
            for (U u : it) {
                set.add(u);
            }
        }
        return new SetSequence(set);
    }

    public static <U> ISetSequence<U> fromSetWithValues(Set<U> set, Iterable<? extends U> it) {
        Set<U> tmp = set;
        if (set == null && it == null) {
            return NullSetSequence.instance();
        }
        if (set == null) {
            tmp = new HashSet<U>();
        } else if (it == null) {
            return SetSequence.fromSet(set);
        }
        if (it instanceof Collection) {
            tmp.addAll((Collection)it);
        } else {
            for (U u : it) {
                tmp.add(u);
            }
        }
        if (tmp instanceof ISetSequence) {
            return (ISetSequence)tmp;
        }
        return new SetSequence<U>(tmp);
    }
}

