/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internal.collections.runtime.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.impl.CardinalityMap;
import jetbrains.mps.internal.collections.runtime.impl.HasNextState;

public class ComparingSequence<U>
extends Sequence<U>
implements Iterable<U> {
    private final ISequence<U> left;
    private final ISequence<U> right;
    private final Kind kind;

    public ComparingSequence(ISequence<U> left, ISequence<U> right, Kind kind) {
        if (left == null || right == null) {
            throw new NullPointerException();
        }
        this.left = left;
        this.right = right;
        this.kind = kind;
    }

    @Override
    public Iterator<U> iterator() {
        return new ComparingIterator();
    }

    private class ComparingIterator
    implements Iterator<U> {
        private CardinalityMap<U> cardMap = new CardinalityMap();
        private List<U> cache;
        private Iterator<U> leftIt;
        private Iterator<U> rightIt;
        private U next;
        private HasNextState hasNext = HasNextState.UNKNOWN;

        private ComparingIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.leftIt == null && this.rightIt == null) {
                this.init();
            }
            if (this.hasNext.unknown()) {
                this.moveToNext();
            }
            return this.hasNext.hasNext();
        }

        @Override
        public U next() {
            if (this.leftIt == null && this.rightIt == null) {
                this.init();
            }
            if (this.hasNext.unknown()) {
                this.moveToNext();
            }
            if (!this.hasNext.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.clearNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void init() {
            switch (ComparingSequence.this.kind) {
                case SUBSTRACTION: 
                case INTERSECTION: {
                    for (Object o : ComparingSequence.this.right.toIterable()) {
                        this.cardMap.postInc(o);
                    }
                    this.leftIt = ComparingSequence.this.left.toIterable().iterator();
                    break;
                }
                case UNION: {
                    this.leftIt = ComparingSequence.this.left.toIterable().iterator();
                    this.rightIt = ComparingSequence.this.right.toIterable().iterator();
                    break;
                }
                case DISJUNCTION: {
                    this.cache = new ArrayList();
                    for (Object o : ComparingSequence.this.right.toIterable()) {
                        this.cardMap.postInc(o);
                        this.cache.add(o);
                    }
                    this.leftIt = ComparingSequence.this.left.toIterable().iterator();
                    this.rightIt = this.cache.iterator();
                    break;
                }
            }
        }

        private void destroy() {
            this.cardMap.clear();
            if (this.cache != null) {
                this.cache.clear();
            }
        }

        private void moveToNext() {
            this.next = null;
            this.hasNext = HasNextState.AT_END;
            block6: while (true) {
                switch (ComparingSequence.this.kind) {
                    case SUBSTRACTION: {
                        if (!this.leftIt.hasNext()) break block6;
                        Object tmp = this.leftIt.next();
                        if (this.cardMap.postDec(tmp) != 0) continue block6;
                        this.setNext(tmp);
                        break block6;
                    }
                    case INTERSECTION: {
                        if (!this.leftIt.hasNext()) break block6;
                        Object tmp = this.leftIt.next();
                        if (this.cardMap.postDec(tmp) <= 0) continue block6;
                        this.setNext(tmp);
                        break block6;
                    }
                    case UNION: {
                        Object tmp;
                        if (this.leftIt.hasNext()) {
                            tmp = this.leftIt.next();
                            this.cardMap.postInc(tmp);
                            this.setNext(tmp);
                            break block6;
                        }
                        if (!this.rightIt.hasNext()) break block6;
                        tmp = this.rightIt.next();
                        if (this.cardMap.postDec(tmp) != 0) continue block6;
                        this.setNext(tmp);
                        break block6;
                    }
                    case DISJUNCTION: {
                        Object tmp;
                        if (this.leftIt.hasNext()) {
                            tmp = this.leftIt.next();
                            if (this.cardMap.postDec(tmp) != 0) continue block6;
                            this.setNext(tmp);
                            break block6;
                        }
                        if (!this.rightIt.hasNext()) break block6;
                        tmp = this.rightIt.next();
                        if (this.cardMap.postDec(tmp) <= 0) continue block6;
                        this.setNext(tmp);
                        break block6;
                    }
                    default: {
                        continue block6;
                    }
                }
                break;
            }
            if (!this.hasNext.hasNext()) {
                this.destroy();
            }
        }

        private U clearNext() {
            Object tmp = this.next;
            this.next = null;
            this.hasNext = HasNextState.UNKNOWN;
            return tmp;
        }

        private void setNext(U tmp) {
            this.next = tmp;
            this.hasNext = HasNextState.HAS_NEXT;
        }
    }

    public static enum Kind {
        UNION,
        INTERSECTION,
        SUBSTRACTION,
        DISJUNCTION;

    }
}

