/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internal.collections.runtime.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.impl.HasNextState;

public class ConcatingSequence<U>
extends Sequence<U> {
    private final ISequence<U> left;
    private final ISequence<U> right;

    public ConcatingSequence(ISequence<U> left, ISequence<U> right) {
        if (left == null || right == null) {
            throw new NullPointerException();
        }
        this.left = left;
        this.right = right;
    }

    @Override
    public Iterator<U> iterator() {
        return new ConcatingIterator();
    }

    private class ConcatingIterator
    implements Iterator<U> {
        private U next;
        private HasNextState hasNext = HasNextState.UNKNOWN;
        private Iterator<U> leftIt;
        private Iterator<U> rightIt;

        private ConcatingIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.leftIt == null || this.rightIt == null) {
                this.init();
            }
            if (this.hasNext.unknown()) {
                this.moveToNext();
            }
            return this.hasNext.hasNext();
        }

        @Override
        public U next() {
            if (this.leftIt == null || this.rightIt == null) {
                this.init();
            }
            if (this.hasNext.unknown()) {
                this.moveToNext();
            }
            if (!this.hasNext.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.clearNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void init() {
            this.leftIt = ConcatingSequence.this.left.toIterable().iterator();
            this.rightIt = ConcatingSequence.this.right.toIterable().iterator();
        }

        private void moveToNext() {
            this.next = null;
            this.hasNext = HasNextState.AT_END;
            if (this.leftIt.hasNext()) {
                this.setNext(this.leftIt.next());
            } else if (this.rightIt.hasNext()) {
                this.setNext(this.rightIt.next());
            }
        }

        private U clearNext() {
            Object tmp = this.next;
            this.next = null;
            this.hasNext = HasNextState.UNKNOWN;
            return tmp;
        }

        private void setNext(U next) {
            this.next = next;
            this.hasNext = HasNextState.HAS_NEXT;
        }
    }
}

