/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internal.collections.runtime.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.SelectComparator;
import jetbrains.mps.internal.collections.runtime.Sequence;

public class SortingSequence<U>
extends Sequence<U>
implements Iterable<U> {
    private final Sequence<U> input;
    private final Comparator<U> comparator;

    public SortingSequence(Sequence<U> input, Comparator<U> comparator, boolean ascending) {
        if (input == null || comparator == null) {
            throw new NullPointerException();
        }
        this.input = input;
        this.comparator = ascending ? comparator : new InversedComparator(comparator);
    }

    public SortingSequence(Sequence<U> input, Comparator<U> comparator) {
        if (input == null || comparator == null) {
            throw new NullPointerException();
        }
        this.input = input;
        this.comparator = comparator;
    }

    @Override
    public Iterator<U> iterator() {
        List<U> sortedInput = this.inputSortedWithSelector();
        return new UnmodifiableIterator<U>(sortedInput.listIterator());
    }

    @Override
    public ISequence<U> alsoSort(_FunctionTypes._return_P1_E0<? extends Comparable<?>, ? super U> selector, boolean ascending) {
        SelectComparator<? super U> selectComparator = new SelectComparator<U>(selector);
        return new SortingSequence<U>(this.input, new CompoundComparator<U>(this.comparator, ascending ? selectComparator : new InversedComparator<U>(selectComparator)));
    }

    private List<U> inputSortedWithSelector() {
        ArrayList cache = new ArrayList();
        for (Object u : this.input) {
            cache.add(u);
        }
        Object[] array = cache.toArray();
        Arrays.sort(array, this.comparator);
        return Arrays.asList(array);
    }

    private static class CompoundComparator<T>
    implements Comparator<T> {
        private final Comparator<T> secondary;
        private final Comparator<T> primary;

        public CompoundComparator(Comparator<T> primary, Comparator<T> secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        @Override
        public int compare(T a, T b) {
            int c = this.primary.compare(a, b);
            return c == 0 ? this.secondary.compare(a, b) : c;
        }
    }

    private static class InversedComparator<T>
    implements Comparator<T> {
        private final Comparator<T> primary;

        public InversedComparator(Comparator<T> primary) {
            this.primary = primary;
        }

        @Override
        public int compare(T a, T b) {
            return -this.primary.compare(a, b);
        }
    }

    private static class UnmodifiableIterator<U>
    implements Iterator<U> {
        private final ListIterator<U> source;

        public UnmodifiableIterator(ListIterator<U> source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public U next() {
            return this.source.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

